/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.task;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.gwtext.client.data.Record;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.form.Form;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.TextField;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.model.TaskRef;
import org.jboss.bpm.console.client.task.AssignmentCallback;
import org.jboss.bpm.console.client.task.TaskList;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.util.ModelChangeListener;
import org.jboss.bpm.console.client.util.ModelListenerRegistry;
import org.jboss.bpm.console.client.widgets.FormWidgets;
import org.jboss.bpm.console.client.widgets.RefreshableComboBox;

class TaskDetailsFormPanel
extends Panel
implements ModelChangeListener {
    private FormPanel formPanel;
    private TaskRef selectedInstance;
    private MainView mainView;
    private Button startBtn;
    private Button stopBtn;
    private Button endBtn;
    private AssignmentCallback callback;

    public TaskDetailsFormPanel(MainView mainView, AssignmentCallback callback) {
        this.mainView = mainView;
        this.callback = callback;
        this.setTitle("Task Details");
        this.setBorder(false);
        this.setFrame(false);
        this.formPanel = FormWidgets.createBaseFormPanel();
        TextField idField = new TextField("Id", "id", 230);
        idField.setReadOnly(true);
        this.formPanel.add((Component)idField);
        TextField nameField = new TextField("Name", "name", 230);
        nameField.setReadOnly(true);
        this.formPanel.add((Component)nameField);
        TextField actorField = new TextField("Actor", "actor", 230);
        actorField.setReadOnly(true);
        this.formPanel.add((Component)actorField);
        TextField stateField = new TextField("State", "currentState", 230);
        stateField.setReadOnly(true);
        this.formPanel.add((Component)stateField);
        RefreshableComboBox cb = new RefreshableComboBox("signal", "Signal");
        this.formPanel.add((Component)cb);
        this.startBtn = new Button("Claim", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        this.stopBtn = new Button("Release", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        this.endBtn = new Button("Complete", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        this.formPanel.addButton(this.startBtn);
        this.formPanel.addButton(this.stopBtn);
        this.formPanel.addButton(this.endBtn);
        this.add((Component)this.formPanel);
    }

    private void reassignTask() {
        RequestBuilder rb = new RequestBuilder(RequestBuilder.POST, this.mainView.getUrlBuilder().getTaskAssignmentURL(this.selectedInstance.getId(), this.selectedInstance.getActor()));
        try {
            rb.sendRequest("", (RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e1) {
            ConsoleLog.error((String)"Request failed", (Throwable)e1);
        }
    }

    private void endTask(String signalName) {
        String taskCloseURL = signalName.equals("default transition") ? this.mainView.getUrlBuilder().getTaskEndURL(this.selectedInstance.getId()) : this.mainView.getUrlBuilder().getTaskEndURL(this.selectedInstance.getId(), signalName);
        RequestBuilder rb = new RequestBuilder(RequestBuilder.POST, taskCloseURL);
        try {
            rb.sendRequest("", (RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e1) {
            ConsoleLog.error((String)"Failed to close task", (Throwable)e1);
        }
    }

    public void onRecordChange(ModelListenerRegistry parent, Record changeEvent) {
        this.selectedInstance = TaskList.transform((Record)changeEvent);
        Form form = this.formPanel.getForm();
        RefreshableComboBox cb = (RefreshableComboBox)form.findField("signal");
        if (this.selectedInstance.getPooledActors().isEmpty()) {
            this.startBtn.disable();
            this.stopBtn.disable();
        } else if (TaskRef.STATE.ASSIGNED == this.selectedInstance.getCurrentState()) {
            this.startBtn.disable();
            this.stopBtn.enable();
            cb.enable();
            this.endBtn.enable();
        } else {
            this.startBtn.enable();
            this.stopBtn.disable();
            cb.disable();
            this.endBtn.disable();
        }
        cb.display(this.selectedInstance.getTransitionNames());
        this.formPanel.getForm().loadRecord(changeEvent);
        this.formPanel.doLayout();
    }

    public void onModelChange(ModelListenerRegistry parent, Object changeEvent) {
    }

    public void onReset() {
        this.formPanel.getForm().reset();
    }

    static /* synthetic */ TaskRef access$000(TaskDetailsFormPanel x0) {
        return x0.selectedInstance;
    }

    static /* synthetic */ void access$100(TaskDetailsFormPanel x0) {
        x0.reassignTask();
    }

    static /* synthetic */ FormPanel access$200(TaskDetailsFormPanel x0) {
        return x0.formPanel;
    }

    static /* synthetic */ void access$300(TaskDetailsFormPanel x0, String x1) {
        x0.endTask(x1);
    }

    static /* synthetic */ TaskRef access$002(TaskDetailsFormPanel x0, TaskRef x1) {
        x0.selectedInstance = x1;
        return x0.selectedInstance;
    }

    static /* synthetic */ AssignmentCallback access$400(TaskDetailsFormPanel x0) {
        return x0.callback;
    }
}

