/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.task;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONObject;
import com.gwtext.client.core.Function;
import com.gwtext.client.core.SortDir;
import com.gwtext.client.data.DataProxy;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.GroupingStore;
import com.gwtext.client.data.IntegerFieldDef;
import com.gwtext.client.data.JsonReader;
import com.gwtext.client.data.Reader;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.ScriptTagProxy;
import com.gwtext.client.data.SortState;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.data.event.StoreListener;
import com.gwtext.client.widgets.PagingToolbar;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.event.PanelListener;
import com.gwtext.client.widgets.grid.AbstractSelectionModel;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.GridPanel;
import com.gwtext.client.widgets.grid.GridView;
import com.gwtext.client.widgets.grid.GroupingView;
import com.gwtext.client.widgets.grid.RowSelectionModel;
import java.util.HashMap;
import java.util.Map;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.model.DTOParser;
import org.jboss.bpm.console.client.model.TaskRef;
import org.jboss.bpm.console.client.task.TaskList;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.util.ModelModificationCallback;

/*
 * Exception performing whole class analysis ignored.
 */
public class TaskList
extends Panel {
    private Map<Integer, TaskRef> row2taskref = new HashMap();
    private MainView mainView;
    private GridPanel grid;
    private GroupingStore store;
    private String title;
    private RowSelectionModel rowSelectionModel;
    public static final int PAGE_SIZE = 15;
    private int selectedRowIndex = -1;
    private ModelModificationCallback modelModificationCallback;

    public TaskList(ModelModificationCallback callback, String titleName, MainView view) {
        this.mainView = view;
        this.title = titleName;
        this.modelModificationCallback = callback;
        this.setPaddings(10);
        this.setHeader(false);
        this.setBorder(false);
        this.setFrame(false);
        this.setIconCls("bpm-task-icon");
        String resourceUrl = view.getUrlBuilder().getTaskListByActorURL(view.getUsername());
        ScriptTagProxy dataProxy = new ScriptTagProxy(resourceUrl, 10000);
        JsonReader reader = this.createReader();
        this.store = new GroupingStore();
        this.store.setReader((Reader)reader);
        this.store.setDataProxy((DataProxy)dataProxy);
        this.store.setSortInfo(new SortState("id", SortDir.ASC));
        this.store.setGroupField("currentState");
        this.store.addStoreListener((StoreListener)new ListViewStoreListener(this, (Panel)this));
        this.addListener((PanelListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void onRecordsLoaded(Record[] records) {
        try {
            int i = 0;
            for (Record r : records) {
                TaskRef ref = TaskList.transform((Record)r);
                this.row2taskref.put(i, ref);
                ++i;
            }
        }
        catch (Throwable e) {
            ConsoleLog.error((String)"Failed to parse task ref", (Throwable)e);
        }
        ConsoleLog.debug((String)("Loaded " + this.row2taskref.size() + " tasks"));
    }

    public static TaskRef transform(Record r) {
        JavaScriptObject js = r.getDataAsJsObject();
        JSONObject jso = new JSONObject(js);
        TaskRef ref = DTOParser.parseTaskReference((JSONObject)jso);
        return ref;
    }

    private ColumnModel createColumnModel() {
        ColumnModel columnModel = new ColumnModel((BaseColumnConfig[])new ColumnConfig[]{new ColumnConfig("ID", "id", 35, true), new ColumnConfig("Task Name", "name", 290, true, null, "expand"), new ColumnConfig("Assigned to", "actor", 75, true), new ColumnConfig("State", "currentState", 50, true)});
        return columnModel;
    }

    private JsonReader createReader() {
        RecordDef recordDef = new RecordDef(new FieldDef[]{new IntegerFieldDef("id"), new StringFieldDef("name"), new StringFieldDef("actor"), new StringFieldDef("currentState")});
        JsonReader reader = new JsonReader(recordDef);
        reader.setRoot("tasks");
        reader.setTotalProperty("totalCount");
        reader.setId("id");
        return reader;
    }

    private GridPanel assembleGrid() {
        ColumnModel columnModel = this.createColumnModel();
        GridPanel grid = new GridPanel();
        grid.setStore((Store)this.store);
        grid.setColumnModel(columnModel);
        grid.setFrame(true);
        grid.setStripeRows(true);
        grid.setAutoExpandColumn("name");
        grid.setTitle(this.title);
        GroupingView gridView = new GroupingView();
        gridView.setForceFit(true);
        gridView.setGroupTextTpl("{text} ({[values.rs.length]} {[values.rs.length > 1 ?  \"Items\" : \"Item\"]})");
        if (this.rowSelectionModel != null) {
            grid.setSelectionModel((AbstractSelectionModel)this.rowSelectionModel);
            grid.doOnRender((Function)new /* Unavailable Anonymous Inner Class!! */, 10);
        }
        grid.setView((GridView)gridView);
        grid.setFrame(true);
        grid.setWidth(450);
        grid.setHeight(250);
        grid.setEnableHdMenu(false);
        grid.setBottomToolbar((Toolbar)this.createToolbar((Store)this.store));
        return grid;
    }

    private PagingToolbar createToolbar(Store store) {
        PagingToolbar pagingToolbar = new PagingToolbar(store);
        pagingToolbar.setPageSize(15);
        pagingToolbar.setDisplayInfo(true);
        pagingToolbar.setDisplayMsg("{0} - {1} of {2}");
        pagingToolbar.addSeparator();
        pagingToolbar.addSpacer();
        return pagingToolbar;
    }

    public void reloadStore() {
        ConsoleLog.debug((String)("Reload " + this.getId()));
        this.store.load(0, 15);
    }

    public GridPanel getGrid() {
        return this.grid;
    }

    public void setRowSelectionModel(RowSelectionModel model) {
        this.rowSelectionModel = model;
    }

    static /* synthetic */ ModelModificationCallback access$000(TaskList x0) {
        return x0.modelModificationCallback;
    }

    static /* synthetic */ GridPanel access$102(TaskList x0, GridPanel x1) {
        x0.grid = x1;
        return x0.grid;
    }

    static /* synthetic */ GridPanel access$200(TaskList x0) {
        return x0.assembleGrid();
    }

    static /* synthetic */ GridPanel access$100(TaskList x0) {
        return x0.grid;
    }

    static /* synthetic */ int access$300(TaskList x0) {
        return x0.selectedRowIndex;
    }

    static /* synthetic */ RowSelectionModel access$400(TaskList x0) {
        return x0.rowSelectionModel;
    }

    static /* synthetic */ int access$302(TaskList x0, int x1) {
        x0.selectedRowIndex = x1;
        return x0.selectedRowIndex;
    }
}

