/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.widgets;

import com.gwtext.client.core.Function;
import com.gwtext.client.data.DataProxy;
import com.gwtext.client.data.JsonReader;
import com.gwtext.client.data.Reader;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.ScriptTagProxy;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.event.StoreListener;
import com.gwtext.client.widgets.PagingToolbar;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.event.PanelListener;
import com.gwtext.client.widgets.grid.AbstractSelectionModel;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.GridPanel;
import com.gwtext.client.widgets.grid.RowSelectionModel;
import com.gwtext.client.widgets.grid.event.GridCellListener;
import org.jboss.bpm.console.client.MainView;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.util.ModelModificationCallback;
import org.jboss.bpm.console.client.widgets.RemoteListView;

public abstract class RemoteListView
extends Panel {
    protected int selectedRowIndex = -1;
    protected MainView view;
    public static final int PAGE_SIZE = 25;
    private GridPanel grid;
    protected String title;
    protected Store store;
    private ToolbarButton addButton;
    private ToolbarButton deleteButton;
    boolean addBtnEnabled = true;
    boolean deleteBtnEnabled = true;
    private RowSelectionModel rowSelectionModel;
    protected String resourceUrl;
    protected ModelModificationCallback modelModificationCallback;

    public RemoteListView(ModelModificationCallback callback, String titleName, MainView view, String resourceUrl) {
        this.modelModificationCallback = callback;
        this.title = titleName;
        this.view = view;
        this.resourceUrl = resourceUrl;
        this.setId(this.getId() + "(" + titleName + ")");
        this.setPaddings(10);
        this.setHeader(false);
        this.setBorder(false);
        this.setFrame(false);
        JsonReader reader = this.createReader();
        ScriptTagProxy dataProxy = new ScriptTagProxy(resourceUrl, 10000);
        this.store = new Store((DataProxy)dataProxy, (Reader)reader, false);
        this.store.addStoreListener((StoreListener)new ListViewStoreListener(this, (Panel)this));
        this.addListener((PanelListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void enableAddBtn(boolean isEnabled) {
        this.addBtnEnabled = isEnabled;
    }

    protected void enableDeleteBtn(boolean isEnabled) {
        this.deleteBtnEnabled = isEnabled;
    }

    protected GridPanel createGridPanel(String titleName) {
        GridPanel grid = new GridPanel();
        grid.setTitle(titleName);
        grid.setFrame(true);
        grid.setWidth(450);
        grid.stripeRows(true);
        grid.setLoadMask(true);
        if (this.rowSelectionModel != null) {
            grid.setSelectionModel((AbstractSelectionModel)this.rowSelectionModel);
            grid.doOnRender((Function)new /* Unavailable Anonymous Inner Class!! */, 10);
        }
        grid.addGridCellListener((GridCellListener)new ListViewCellListener(this));
        return grid;
    }

    private PagingToolbar createToolbar(Store store) {
        PagingToolbar pagingToolbar = new PagingToolbar(store);
        pagingToolbar.setPageSize(25);
        pagingToolbar.setDisplayInfo(true);
        pagingToolbar.setDisplayMsg("{0} - {1} of {2}");
        pagingToolbar.addSeparator();
        pagingToolbar.addSpacer();
        ToolbarButton examineButton = new ToolbarButton("Examine", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        examineButton.setTooltip("Examine");
        pagingToolbar.addButton(examineButton);
        if (this.addBtnEnabled) {
            this.addButton = new ToolbarButton("Add", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
            this.addButton.setTooltip("Add");
            pagingToolbar.addButton(this.addButton);
        }
        if (this.deleteBtnEnabled) {
            this.deleteButton = new ToolbarButton("Remove", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
            this.deleteButton.setTooltip("Remove");
            pagingToolbar.addButton(this.deleteButton);
        }
        return pagingToolbar;
    }

    public abstract void onAdd();

    public abstract void onExamine(int var1);

    public abstract void onDelete(int var1);

    protected abstract void onRecordsLoaded(Record[] var1);

    protected abstract ColumnModel createColumnModel();

    protected abstract JsonReader createReader();

    private GridPanel assembleGrid() {
        GridPanel grid = this.createGridPanel(this.title);
        ColumnModel columnModel = this.createColumnModel();
        grid.setColumnModel(columnModel);
        grid.setAutoExpandColumn("expand");
        grid.setStore(this.store);
        PagingToolbar pagingToolbar = this.createToolbar(this.store);
        grid.setBottomToolbar((Toolbar)pagingToolbar);
        if (this.rowSelectionModel != null) {
            grid.setSelectionModel((AbstractSelectionModel)this.rowSelectionModel);
        }
        return grid;
    }

    public GridPanel getGrid() {
        return this.grid;
    }

    public void reloadStore() {
        ConsoleLog.debug((String)("Reload " + this.getId()));
        this.store.load(0, 25);
    }

    public void setRowSelectionModel(RowSelectionModel rowSelectionModel) {
        this.rowSelectionModel = rowSelectionModel;
    }

    static /* synthetic */ RowSelectionModel access$000(RemoteListView x0) {
        return x0.rowSelectionModel;
    }

    static /* synthetic */ GridPanel access$102(RemoteListView x0, GridPanel x1) {
        x0.grid = x1;
        return x0.grid;
    }

    static /* synthetic */ GridPanel access$200(RemoteListView x0) {
        return x0.assembleGrid();
    }

    static /* synthetic */ GridPanel access$100(RemoteListView x0) {
        return x0.grid;
    }
}

