/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.ejbtimer;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.command.Command;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.job.Timer;

public class ExecuteTimerCommand
implements Command {
    private final long timerId;
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog((Class)ExecuteTimerCommand.class);

    public ExecuteTimerCommand(long timerId) {
        this.timerId = timerId;
    }

    public Object execute(JbpmContext jbpmContext) throws Exception {
        Timer timer = ExecuteTimerCommand.acquireTimer(this.timerId, jbpmContext);
        if (timer != null) {
            ExecuteTimerCommand.executeTimer(timer, jbpmContext);
        }
        return timer;
    }

    private static Timer acquireTimer(long timerId, JbpmContext jbpmContext) {
        Timer timer;
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("acquiring timer: " + timerId));
        }
        if ((timer = (Timer)jbpmContext.getSession().get(Timer.class, (Serializable)new Long(timerId))) != null) {
            ProcessInstance processInstance = timer.getProcessInstance();
            jbpmContext.addAutoSaveProcessInstance(processInstance);
            timer.setLockOwner(Thread.currentThread().getName());
            if (debug) {
                log.debug((Object)("acquired " + timer));
            }
        } else if (debug) {
            log.debug((Object)("timer not found: " + timerId));
        }
        return timer;
    }

    private static void executeTimer(Timer timer, JbpmContext jbpmContext) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("executing " + timer));
        }
        if (timer.execute(jbpmContext)) {
            jbpmContext.getServices().getSchedulerService().deleteTimer(timer);
        }
    }
}

