/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.ejbtimer;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.TimedObject;
import javax.ejb.TimerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.ejb.LocalCommandService;
import org.jbpm.ejb.LocalCommandServiceHome;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Timer;
import org.jbpm.scheduler.ejbtimer.ExecuteTimerCommand;
import org.jbpm.scheduler.ejbtimer.TimerInfo;
import org.jbpm.util.JndiUtil;

public class TimerServiceBean
implements SessionBean,
TimedObject {
    private static final long serialVersionUID = 1L;
    private LocalCommandService commandService;
    private SessionContext sessionContext;
    private static final Log log = LogFactory.getLog((Class)TimerServiceBean.class);

    public void ejbCreate() {
        try {
            LocalCommandServiceHome commandServiceHome = (LocalCommandServiceHome)JndiUtil.lookup((String)"java:comp/env/ejb/LocalCommandServiceBean", (Class)LocalCommandServiceHome.class);
            this.commandService = commandServiceHome.create();
        }
        catch (CreateException e) {
            throw new EJBException("command service creation failed", (Exception)((Object)e));
        }
    }

    public void createTimer(Timer timer) {
        TimerService timerService = this.sessionContext.getTimerService();
        javax.ejb.Timer ejbTimer = timerService.createTimer(timer.getDueDate(), (Serializable)new TimerInfo(timer));
        log.debug((Object)("created " + ejbTimer));
    }

    public void cancelTimer(Timer timer) {
        long timerId = timer.getId();
        Collection timers = this.sessionContext.getTimerService().getTimers();
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("examining " + timers.size() + " timers by id " + timerId));
        }
        int count = 0;
        Iterator i = timers.iterator();
        while (i.hasNext()) {
            TimerInfo timerInfo;
            javax.ejb.Timer ejbTimer = (javax.ejb.Timer)i.next();
            if (!(ejbTimer.getInfo() instanceof TimerInfo) || timerId != (timerInfo = (TimerInfo)ejbTimer.getInfo()).getTimerId()) continue;
            ejbTimer.cancel();
            ++count;
        }
        if (debug) {
            log.debug((Object)("canceled " + count + " timers by id " + timerId));
        }
    }

    public void cancelTimersByName(String timerName, Token token) {
        Collection timers = this.sessionContext.getTimerService().getTimers();
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("examining " + timers.size() + " timers by name '" + timerName + "' for " + token));
        }
        int count = 0;
        Iterator i = timers.iterator();
        while (i.hasNext()) {
            TimerInfo timerInfo;
            javax.ejb.Timer ejbTimer = (javax.ejb.Timer)i.next();
            if (!(ejbTimer.getInfo() instanceof TimerInfo) || !(timerInfo = (TimerInfo)ejbTimer.getInfo()).matchesName(timerName, token)) continue;
            ejbTimer.cancel();
            ++count;
        }
        if (debug) {
            log.debug((Object)("canceled " + count + " timers by name '" + timerName + "' for " + token));
        }
    }

    public void cancelTimersForProcessInstance(ProcessInstance processInstance) {
        Collection timers = this.sessionContext.getTimerService().getTimers();
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("examining " + timers.size() + " timers for " + processInstance));
        }
        int count = 0;
        Iterator i = timers.iterator();
        while (i.hasNext()) {
            TimerInfo timerInfo;
            javax.ejb.Timer ejbTimer = (javax.ejb.Timer)i.next();
            if (!(ejbTimer.getInfo() instanceof TimerInfo) || !(timerInfo = (TimerInfo)ejbTimer.getInfo()).matchesProcessInstance(processInstance)) continue;
            ejbTimer.cancel();
            ++count;
        }
        if (debug) {
            log.debug((Object)("canceled " + count + " timers for " + processInstance));
        }
    }

    public void ejbTimeout(javax.ejb.Timer ejbTimer) {
        TimerInfo timerInfo;
        Timer timer;
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)(ejbTimer + " fired"));
        }
        if ((timer = (Timer)this.commandService.execute(new ExecuteTimerCommand((timerInfo = (TimerInfo)ejbTimer.getInfo()).getTimerId()))) != null && timer.getRepeat() != null) {
            if (debug) {
                log.debug((Object)("scheduling timer for repeat at " + timer.getDueDate()));
            }
            this.createTimer(timer);
        }
    }

    public void setSessionContext(SessionContext sessionContext) throws EJBException, RemoteException {
        this.sessionContext = sessionContext;
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    public void ejbRemove() throws EJBException, RemoteException {
        this.commandService = null;
    }
}

