/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ejb.impl;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.command.Command;
import org.jbpm.db.JobSession;
import org.jbpm.ejb.impl.ExecuteJobsCommand;
import org.jbpm.job.Job;
import org.jbpm.msg.jms.JmsMessageService;
import org.jbpm.msg.jms.JmsMessageServiceFactory;
import org.jbpm.svc.Services;

public class ExecuteJobCommand
implements Command {
    private final long jobId;
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(ExecuteJobCommand.class);

    public ExecuteJobCommand(long jobId) {
        this.jobId = jobId;
    }

    public Object execute(JbpmContext jbpmContext) throws Exception {
        JobSession jobSession = jbpmContext.getJobSession();
        Job job = jobSession.getJob(this.jobId);
        if (job == null) {
            log.debug((Object)("job " + this.jobId + " was deleted"));
            return null;
        }
        String lockOwner = job.getLockOwner();
        if (lockOwner != null) {
            log.debug((Object)(job + " is locked by " + lockOwner));
            return null;
        }
        lockOwner = Long.toString(this.jobId);
        if (job.isExclusive()) {
            List exclusiveJobs = jobSession.findExclusiveJobs(lockOwner, job.getProcessInstance());
            int jobCount = exclusiveJobs.size();
            if (jobCount == 0) {
                log.debug((Object)(job + " was locked during attempt to lock other jobs"));
                return null;
            }
            long[] exclusiveJobIds = new long[jobCount];
            for (int i = 0; i < jobCount; ++i) {
                Job exclusiveJob = (Job)exclusiveJobs.get(i);
                exclusiveJob.setLockOwner(lockOwner);
                exclusiveJobIds[i] = exclusiveJob.getId();
            }
            log.debug((Object)("locking jobs " + Arrays.toString(exclusiveJobIds)));
            ExecuteJobCommand.postJobsExecution(jbpmContext, exclusiveJobIds);
        } else {
            job.setLockOwner(lockOwner);
            log.debug((Object)("executing " + job));
            ExecuteJobCommand.executeJob(job, jbpmContext);
        }
        return null;
    }

    static void executeJob(Job job, JbpmContext jbpmContext) {
        try {
            if (job.execute(jbpmContext)) {
                jbpmContext.getJobSession().deleteJob(job);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)("exception while executing " + job), (Throwable)e);
            StringWriter memoryWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(memoryWriter));
            job.setException(memoryWriter.toString());
            job.setRetries(job.getRetries() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void postJobsExecution(JbpmContext jbpmContext, long[] exclusiveJobIds) throws NamingException, JMSException {
        Services services = jbpmContext.getServices();
        JmsMessageServiceFactory messageServiceFactory = (JmsMessageServiceFactory)services.getServiceFactory("message");
        Destination destination = messageServiceFactory.getCommandDestination();
        JmsMessageService messageService = (JmsMessageService)services.getMessageService();
        Session session = messageService.getSession();
        MessageProducer producer = session.createProducer(destination);
        try {
            ExecuteJobsCommand command = new ExecuteJobsCommand(exclusiveJobIds);
            ObjectMessage message = session.createObjectMessage((Serializable)((Object)command));
            producer.send((Message)message);
        }
        finally {
            producer.close();
        }
    }
}

