/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.msg.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jbpm.JbpmException;
import org.jbpm.msg.jms.JmsMessageService;
import org.jbpm.svc.Service;
import org.jbpm.svc.ServiceFactory;

public class JmsMessageServiceFactory
implements ServiceFactory {
    private static final long serialVersionUID = 1L;
    String connectionFactoryJndiName = "java:JmsXA";
    String destinationJndiName = "queue/JbpmJobQueue";
    String commandDestinationJndiName = "queue/JbpmCommandQueue";
    boolean isCommitEnabled = false;
    private ConnectionFactory connectionFactory;
    private Destination destination;
    private Destination commandDestination;

    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            try {
                this.connectionFactory = (ConnectionFactory)JmsMessageServiceFactory.lookup(this.connectionFactoryJndiName);
            }
            catch (NamingException e) {
                throw new JbpmException("could not retrieve message connection factory", (Throwable)e);
            }
        }
        return this.connectionFactory;
    }

    public Destination getDestination() {
        if (this.destination == null) {
            try {
                this.destination = (Destination)JmsMessageServiceFactory.lookup(this.destinationJndiName);
            }
            catch (NamingException e) {
                throw new JbpmException("could not retrieve job destination", (Throwable)e);
            }
        }
        return this.destination;
    }

    public Destination getCommandDestination() {
        if (this.commandDestination == null) {
            try {
                this.commandDestination = (Destination)JmsMessageServiceFactory.lookup(this.commandDestinationJndiName);
            }
            catch (NamingException e) {
                throw new JbpmException("could not retrieve command destination", (Throwable)e);
            }
        }
        return this.commandDestination;
    }

    public boolean isCommitEnabled() {
        return this.isCommitEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object lookup(String name) throws NamingException {
        InitialContext initial = new InitialContext();
        try {
            Object object = initial.lookup(name);
            return object;
        }
        finally {
            initial.close();
        }
    }

    public Service openService() {
        try {
            Connection connection = this.getConnectionFactory().createConnection();
            return new JmsMessageService(connection, this.getDestination(), this.isCommitEnabled);
        }
        catch (JMSException e) {
            throw new JbpmException("couldn't open message session", (Throwable)e);
        }
    }

    public void close() {
        this.connectionFactory = null;
        this.destination = null;
        this.commandDestination = null;
    }
}

