/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ejb.impl;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.command.Command;
import org.jbpm.command.CommandService;
import org.jbpm.tx.TxService;

public class CommandServiceBean
implements SessionBean,
CommandService {
    private static final long serialVersionUID = 1L;
    JbpmConfiguration jbpmConfiguration = null;
    SessionContext sessionContext = null;
    private static final Log log = LogFactory.getLog(CommandServiceBean.class);

    public void ejbCreate() throws CreateException {
        String jbpmCfgResource = null;
        try {
            log.debug((Object)"getting jbpm configuration resource from the environment properties");
            InitialContext initial = new InitialContext();
            jbpmCfgResource = (String)initial.lookup("java:comp/env/JbpmCfgResource");
        }
        catch (NamingException e) {
            log.debug((Object)"couldn't find configuration property JbpmCfgResource through JNDI");
        }
        if (log.isDebugEnabled()) {
            if (jbpmCfgResource == null) {
                log.debug((Object)"getting default jbpm configuration resource (jbpm.cfg.xml)");
            } else {
                log.debug((Object)("getting jbpm configuration from resource " + jbpmCfgResource));
            }
        }
        this.jbpmConfiguration = JbpmConfiguration.getInstance(jbpmCfgResource);
    }

    public Object execute(Command command) {
        Object result = null;
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            log.debug((Object)("executing " + command));
            result = command.execute(jbpmContext);
            TxService txService = jbpmContext.getServices().getTxService();
            if (txService.isRollbackOnly()) {
                this.sessionContext.setRollbackOnly();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JbpmException("failed to execute " + command, (Throwable)e);
        }
        finally {
            jbpmContext.close();
        }
        return result;
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void ejbRemove() {
        this.sessionContext = null;
        this.jbpmConfiguration = null;
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }
}

