/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.ejbtimer;

import java.io.Serializable;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Timer;

public class TimerInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    long timerId = -1L;
    String timerName;
    long tokenId = -1L;
    long processInstanceId = -1L;

    public TimerInfo(Timer timer) {
        this.timerId = timer.getId();
        this.timerName = timer.getName();
        Token token = timer.getToken();
        this.tokenId = token != null ? token.getId() : -1L;
        ProcessInstance processInstance = timer.getProcessInstance();
        this.processInstanceId = processInstance != null ? processInstance.getId() : -1L;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public long getTimerId() {
        return this.timerId;
    }

    public String getTimerName() {
        return this.timerName;
    }

    public long getTokenId() {
        return this.tokenId;
    }

    public boolean matchesName(String timerName, Token token) {
        return this.timerName != null && this.timerName.equals(timerName) && this.tokenId != -1L && this.tokenId == token.getId();
    }

    public boolean matchesProcessInstance(ProcessInstance processInstance) {
        return this.processInstanceId != -1L && processInstance != null && this.processInstanceId == processInstance.getId();
    }
}

