/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.identity.hibernate;

import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.identity.Entity;
import org.jbpm.identity.Group;
import org.jbpm.identity.Membership;
import org.jbpm.identity.User;
import org.jbpm.identity.assignment.ExpressionSession;
import org.jbpm.identity.security.IdentityService;
import org.jbpm.persistence.JbpmPersistenceException;

public class IdentitySession
implements IdentityService,
ExpressionSession {
    private final Session session;
    private Transaction transaction;

    public IdentitySession(Session session) {
        this.session = session;
    }

    public IdentitySession() {
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext == null) {
            throw new JbpmException("no active jbpm context");
        }
        this.session = jbpmContext.getSession();
        if (this.session == null) {
            throw new JbpmException("no active hibernate session");
        }
    }

    public Object verify(String userName, String pwd) {
        return this.session.createCriteria(User.class).setProjection((Projection)Projections.property((String)"id")).add((Criterion)Restrictions.eq((String)"name", (Object)userName)).add((Criterion)Restrictions.eq((String)"password", (Object)pwd)).uniqueResult();
    }

    public User getUserById(Object userId) {
        return (User)this.session.load(User.class, (Serializable)((Long)userId));
    }

    public Session getSession() {
        return this.session;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void beginTransaction() {
        try {
            this.transaction = this.session.beginTransaction();
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not begin transaction", (Throwable)e);
        }
    }

    public void commitTransaction() {
        if (this.transaction == null) {
            throw new JbpmException("cannot commit: no transaction started");
        }
        try {
            this.session.flush();
            this.transaction.commit();
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not commit transaction", (Throwable)e);
        }
        this.transaction = null;
    }

    public void rollbackTransaction() {
        if (this.transaction == null) {
            throw new JbpmException("cannot rollback: no transaction started");
        }
        try {
            this.transaction.rollback();
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not rollback transaction", (Throwable)e);
        }
        this.transaction = null;
    }

    public void commitTransactionAndClose() {
        this.commitTransaction();
        this.close();
    }

    public void rollbackTransactionAndClose() {
        this.rollbackTransaction();
        this.close();
    }

    public void close() {
        try {
            this.session.close();
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not close hibernate session", (Throwable)e);
        }
    }

    public void saveUser(User user) {
        this.session.save((Object)user);
    }

    public void saveGroup(Group group) {
        this.session.save((Object)group);
    }

    public void saveEntity(Entity entity) {
        this.session.save((Object)entity);
    }

    public void saveMembership(Membership membership) {
        this.session.save((Object)membership);
    }

    public User loadUser(long userId) {
        return (User)this.session.load(User.class, (Serializable)new Long(userId));
    }

    public Group loadGroup(long groupId) {
        return (Group)this.session.load(Group.class, (Serializable)new Long(groupId));
    }

    public void deleteGroup(Group group) {
        this.session.delete((Object)group);
    }

    public void deleteUser(User user) {
        this.session.delete((Object)user);
    }

    public void deleteEntity(Entity entity) {
        this.session.delete((Object)entity);
    }

    public User getUserByName(String userName) {
        return (User)this.session.createCriteria(User.class).add((Criterion)Restrictions.eq((String)"name", (Object)userName)).setMaxResults(1).uniqueResult();
    }

    public Group getGroupByName(String groupName) {
        return (Group)this.session.createCriteria(Group.class).add((Criterion)Restrictions.eq((String)"name", (Object)groupName)).setMaxResults(1).uniqueResult();
    }

    public List getUsers() {
        return this.session.createCriteria(User.class).list();
    }

    public List getGroupNamesByUserAndGroupType(String userName, String groupType) {
        return this.session.createCriteria(Membership.class).createAlias("group", "g").createAlias("user", "u").add((Criterion)Restrictions.eq((String)"u.name", (Object)userName)).add((Criterion)Restrictions.eq((String)"g.type", (Object)groupType)).setProjection((Projection)Projections.property((String)"g.name")).list();
    }

    public User getUserByGroupAndRole(String groupName, String role) {
        return (User)this.session.createCriteria(Membership.class).createAlias("group", "g").add((Criterion)Restrictions.eq((String)"role", (Object)role)).add((Criterion)Restrictions.eq((String)"g.name", (Object)groupName)).setProjection((Projection)Projections.property((String)"user")).uniqueResult();
    }
}

