/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.identity.hibernate;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.util.JDBCExceptionReporter;
import org.jbpm.JbpmException;
import org.jbpm.identity.hibernate.IdentitySessionFactory;

public class IdentitySchema {
    private static final String IDENTITY_TABLE_PATTERN = "JBPM_ID_%";
    private static final String[] TABLE_TYPES = new String[]{"TABLE"};
    private final Configuration configuration;
    private ConnectionProvider connectionProvider;
    private static String sqlDelimiter;

    public IdentitySchema(Configuration configuration) {
        this.configuration = configuration;
    }

    private Dialect getDialect() {
        return Dialect.getDialect((Properties)this.configuration.getProperties());
    }

    private String getDefaultCatalog() {
        return this.configuration.getProperty("hibernate.default_catalog");
    }

    private String getDefaultSchema() {
        return this.configuration.getProperty("hibernate.default_schema");
    }

    public String[] getCreateSql() {
        return this.configuration.generateSchemaCreationScript(this.getDialect());
    }

    public String[] getDropSql() {
        return this.configuration.generateDropSchemaScript(this.getDialect());
    }

    public String[] getCleanSql() {
        ArrayList<String> dropForeignKeysSql = new ArrayList<String>();
        ArrayList<String> createForeignKeysSql = new ArrayList<String>();
        Dialect dialect = this.getDialect();
        String defaultCatalog = this.getDefaultCatalog();
        String defaultSchema = this.getDefaultSchema();
        Mapping mapping = this.configuration.buildMapping();
        Iterator tm = this.configuration.getTableMappings();
        while (tm.hasNext()) {
            Table table = (Table)tm.next();
            if (!table.isPhysicalTable()) continue;
            Iterator subIter = table.getForeignKeyIterator();
            while (subIter.hasNext()) {
                ForeignKey foreignKey = (ForeignKey)subIter.next();
                if (!foreignKey.isPhysicalConstraint()) continue;
                dropForeignKeysSql.add(foreignKey.sqlDropString(dialect, defaultCatalog, defaultSchema));
                createForeignKeysSql.add(foreignKey.sqlCreateString(dialect, mapping, defaultCatalog, defaultSchema));
            }
        }
        ArrayList<String> deleteSql = dropForeignKeysSql;
        Iterator iter = this.configuration.getTableMappings();
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            deleteSql.add("delete from " + table.getName());
        }
        ArrayList<String> cleanSqlList = dropForeignKeysSql;
        cleanSqlList.addAll(createForeignKeysSql);
        return cleanSqlList.toArray(new String[cleanSqlList.size()]);
    }

    public boolean hasIdentityTables() {
        return !this.getIdentityTables().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getIdentityTables() {
        Connection connection = null;
        try {
            connection = this.createConnection();
            ArrayList<String> identityTables = new ArrayList<String>();
            ResultSet resultSet = connection.getMetaData().getTables(null, null, IDENTITY_TABLE_PATTERN, TABLE_TYPES);
            try {
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (tableName == null || tableName.length() <= 5 || !IDENTITY_TABLE_PATTERN.equalsIgnoreCase(tableName.substring(0, 5))) continue;
                    identityTables.add(tableName);
                }
            }
            finally {
                resultSet.close();
            }
            ArrayList<String> arrayList = identityTables;
            return arrayList;
        }
        catch (SQLException e) {
            throw new JbpmException("could not get identity tables");
        }
        finally {
            this.closeConnection(connection);
        }
    }

    public void dropSchema() {
        this.execute(this.getDropSql());
    }

    public void createSchema() {
        this.execute(this.getCreateSql());
    }

    public void cleanSchema() {
        this.execute(this.getCleanSql());
    }

    public void saveSqlScripts(String dir, String prefix) {
        try {
            new File(dir).mkdirs();
            this.saveSqlScript(dir + "/" + prefix + ".drop.sql", this.getDropSql());
            this.saveSqlScript(dir + "/" + prefix + ".create.sql", this.getCreateSql());
            this.saveSqlScript(dir + "/" + prefix + ".clean.sql", this.getCleanSql());
            new SchemaExport(this.configuration).setDelimiter(this.getSqlDelimiter()).setOutputFile(dir + "/" + prefix + ".drop.create.sql").create(true, false);
        }
        catch (IOException e) {
            throw new JbpmException("couldn't generate scripts", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            IdentitySchema.syntax();
        } else if ("create".equalsIgnoreCase(args[0])) {
            new IdentitySchema(IdentitySessionFactory.createConfiguration()).createSchema();
        } else if ("drop".equalsIgnoreCase(args[0])) {
            new IdentitySchema(IdentitySessionFactory.createConfiguration()).dropSchema();
        } else if ("clean".equalsIgnoreCase(args[0])) {
            new IdentitySchema(IdentitySessionFactory.createConfiguration()).cleanSchema();
        } else if ("scripts".equalsIgnoreCase(args[0]) && args.length == 3) {
            new IdentitySchema(IdentitySessionFactory.createConfiguration()).saveSqlScripts(args[1], args[2]);
        } else {
            IdentitySchema.syntax();
        }
    }

    private static void syntax() {
        System.err.println("syntax:");
        System.err.println("IdentitySchema create");
        System.err.println("IdentitySchema drop");
        System.err.println("IdentitySchema clean");
        System.err.println("IdentitySchema scripts <dir> <prefix>");
    }

    private void saveSqlScript(String fileName, String[] sql) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(fileName);
        PrintStream printStream = new PrintStream(fileOutputStream);
        for (int i = 0; i < sql.length; ++i) {
            printStream.println(sql[i] + this.getSqlDelimiter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String[] script) {
        Connection connection = null;
        try {
            connection = this.createConnection();
            Statement statement = connection.createStatement();
            try {
                boolean showSql = this.getShowSql();
                for (int i = 0; i < script.length; ++i) {
                    String sql = script[i];
                    if (showSql) {
                        System.out.println(sql);
                    }
                    statement.executeUpdate(sql);
                }
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException e) {
            throw new JbpmException("failed to execute sql", (Throwable)e);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private boolean getShowSql() {
        return "true".equalsIgnoreCase(this.configuration.getProperty("hibernate.show_sql"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Connection connection) {
        if (this.connectionProvider != null) {
            try {
                if (connection != null) {
                    JDBCExceptionReporter.logAndClearWarnings((Connection)connection);
                    this.connectionProvider.closeConnection(connection);
                }
            }
            catch (SQLException e) {
                JDBCExceptionReporter.logExceptions((SQLException)e);
            }
            finally {
                this.connectionProvider.close();
                this.connectionProvider = null;
            }
        }
    }

    private Connection createConnection() throws SQLException {
        try {
            this.connectionProvider = ConnectionProviderFactory.newConnectionProvider((Properties)this.configuration.getProperties());
        }
        catch (HibernateException e) {
            throw new SQLException(e.getMessage());
        }
        Connection connection = this.connectionProvider.getConnection();
        if (!connection.getAutoCommit()) {
            connection.commit();
            connection.setAutoCommit(true);
        }
        return connection;
    }

    public Properties getProperties() {
        return this.configuration.getProperties();
    }

    private synchronized String getSqlDelimiter() {
        if (sqlDelimiter == null) {
            sqlDelimiter = this.getProperties().getProperty("jbpm.sql.delimiter", ";");
        }
        return sqlDelimiter;
    }
}

