/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.identity.assignment;

import java.util.Set;
import org.jbpm.JbpmContext;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.identity.Entity;
import org.jbpm.identity.Group;
import org.jbpm.identity.User;
import org.jbpm.identity.assignment.ExpressionAssignmentException;
import org.jbpm.identity.assignment.ExpressionSession;
import org.jbpm.identity.assignment.TermTokenizer;
import org.jbpm.identity.hibernate.IdentitySession;
import org.jbpm.security.SecurityHelper;
import org.jbpm.taskmgmt.def.AssignmentHandler;
import org.jbpm.taskmgmt.exe.Assignable;
import org.jbpm.taskmgmt.exe.SwimlaneInstance;

public class ExpressionAssignmentHandler
implements AssignmentHandler {
    private static final long serialVersionUID = 1L;
    protected String expression;
    protected ExecutionContext executionContext;
    protected ExpressionSession expressionSession;
    protected TermTokenizer tokenizer;
    protected Entity entity;

    public void assign(Assignable assignable, ExecutionContext executionContext) {
        this.expressionSession = this.getExpressionSession();
        if (this.expressionSession == null) {
            throw new ExpressionAssignmentException("no expression session");
        }
        this.tokenizer = new TermTokenizer(this.expression);
        this.executionContext = executionContext;
        this.entity = this.resolveFirstTerm(this.tokenizer.nextTerm());
        while (this.tokenizer.hasMoreTerms() && this.entity != null) {
            this.entity = this.resolveNextTerm(this.tokenizer.nextTerm());
        }
        if (this.entity == null) {
            throw new ExpressionAssignmentException("could not resolve assignment expression: " + this.expression);
        }
        if (this.entity instanceof User) {
            assignable.setActorId(this.entity.getName());
        } else if (this.entity instanceof Group) {
            assignable.setPooledActors(new String[]{this.entity.getName()});
        }
    }

    protected ExpressionSession getExpressionSession() {
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext == null) {
            throw new ExpressionAssignmentException("no current jbpm context");
        }
        return (IdentitySession)jbpmContext.getServices().getPersistenceService().getCustomSession(IdentitySession.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Entity resolveFirstTerm(String term) {
        if (term.equalsIgnoreCase("previous")) {
            String userName = SecurityHelper.getAuthenticatedActorId();
            return this.getUserByName(userName);
        }
        if (term.startsWith("swimlane(") && term.endsWith(")")) {
            String swimlaneName = term.substring(9, term.length() - 1).trim();
            String userName = this.getSwimlaneActorId(swimlaneName);
            return this.getUserByName(userName);
        }
        if (term.startsWith("variable(") && term.endsWith(")")) {
            String variableName = term.substring(9, term.length() - 1).trim();
            Object value = this.getVariable(variableName);
            if (value instanceof String) {
                return this.getUserByName((String)value);
            }
            if (!(value instanceof Entity)) throw new ExpressionAssignmentException(value + " is neither user name nor entity");
            return (Entity)value;
        }
        if (term.startsWith("user(") && term.endsWith(")")) {
            String userName = term.substring(5, term.length() - 1).trim();
            return this.getUserByName(userName);
        }
        if (!term.startsWith("group(")) throw new ExpressionAssignmentException("could not interpret first term: " + term);
        if (!term.endsWith(")")) throw new ExpressionAssignmentException("could not interpret first term: " + term);
        String groupName = term.substring(6, term.length() - 1).trim();
        return this.getGroupByName(groupName);
    }

    protected Entity resolveNextTerm(String term) {
        if (term.startsWith("group(") && term.endsWith(")")) {
            User user = (User)this.entity;
            String groupType = term.substring(6, term.length() - 1).trim();
            Set groups = user.getGroupsForGroupType(groupType);
            if (groups.isEmpty()) {
                throw new ExpressionAssignmentException("no groups for type: " + groupType);
            }
            this.entity = (Entity)groups.iterator().next();
        } else if (term.startsWith("member(") && term.endsWith(")")) {
            String role = term.substring(7, term.length() - 1).trim();
            Group group = (Group)this.entity;
            this.entity = this.expressionSession.getUserByGroupAndRole(group.getName(), role);
            if (this.entity == null) {
                throw new ExpressionAssignmentException("no users in role: " + role);
            }
        } else {
            throw new ExpressionAssignmentException("could not interpret term: " + term);
        }
        return this.entity;
    }

    protected Object getVariable(String variableName) {
        Token token = this.executionContext.getToken();
        return this.executionContext.getContextInstance().getVariable(variableName, token);
    }

    protected Entity getGroupByName(String groupName) {
        Group group = this.expressionSession.getGroupByName(groupName);
        if (group == null) {
            throw new ExpressionAssignmentException("no such group: " + groupName);
        }
        return group;
    }

    protected Entity getUserByName(String userName) {
        User user = this.expressionSession.getUserByName(userName);
        if (user == null) {
            throw new ExpressionAssignmentException("no such user: " + user);
        }
        return user;
    }

    protected String getSwimlaneActorId(String swimlaneName) {
        SwimlaneInstance swimlaneInstance = this.executionContext.getTaskMgmtInstance().getSwimlaneInstance(swimlaneName);
        if (swimlaneInstance == null) {
            throw new ExpressionAssignmentException("no such swimlane: " + swimlaneName);
        }
        return swimlaneInstance.getActorId();
    }
}

