/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.identity.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.ant.AntHelper;
import org.jbpm.identity.Entity;
import org.jbpm.identity.hibernate.IdentitySession;
import org.jbpm.identity.xml.IdentityXmlParser;

public class LoadIdentitiesTask
extends Task {
    private File file;
    private String jbpmCfg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        FileInputStream fileInputStream;
        JbpmConfiguration jbpmConfiguration = AntHelper.getJbpmConfiguration((String)this.jbpmCfg);
        if (this.file == null) {
            throw new BuildException("no file specified in the loadidentities task");
        }
        this.log("loading identities from " + this.file + " ...");
        try {
            fileInputStream = new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("identities file '" + this.file + "' not found");
        }
        Entity[] entities = IdentityXmlParser.parseEntitiesResource(fileInputStream);
        JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
        try {
            IdentitySession identitySession = (IdentitySession)jbpmContext.getServices().getPersistenceService().getCustomSession(IdentitySession.class);
            for (int i = 0; i < entities.length; ++i) {
                identitySession.saveEntity(entities[i]);
            }
        }
        finally {
            jbpmContext.close();
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setJbpmCfg(String jbpmCfg) {
        this.jbpmCfg = jbpmCfg;
    }
}

