/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.identity.xml;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jbpm.JbpmException;
import org.jbpm.identity.Entity;
import org.jbpm.identity.Group;
import org.jbpm.identity.Membership;
import org.jbpm.identity.User;
import org.jbpm.util.ClassLoaderUtil;

public class IdentityXmlParser {
    private List entities = new ArrayList();
    private Map users = new HashMap();
    private Map groups = new HashMap();

    public static Entity[] parseEntitiesResource(String resource) {
        return new IdentityXmlParser().parse(resource);
    }

    public static Entity[] parseEntitiesResource(InputStream inputStream) {
        return new IdentityXmlParser().parse(inputStream);
    }

    public Entity[] parse(String resource) {
        try {
            URL resourceUrl = ClassLoaderUtil.getClassLoader().getResource(resource);
            return this.parse(new SAXReader().read(resourceUrl));
        }
        catch (DocumentException e) {
            throw new JbpmException("could not read identity resource: " + resource, (Throwable)e);
        }
    }

    public Entity[] parse(InputStream inputStream) {
        try {
            return this.parse(new SAXReader().read(inputStream));
        }
        catch (DocumentException e) {
            throw new JbpmException("could not read identity document", (Throwable)e);
        }
    }

    private Entity[] parse(Document document) {
        Element identitiesElement = document.getRootElement();
        this.readUsers(identitiesElement.elements("user"));
        this.readGroups(identitiesElement.elements("group"));
        this.readParentGroups(identitiesElement.elements("group"));
        this.readMemberships(identitiesElement.elements("membership"));
        return this.entities.toArray(new Entity[this.entities.size()]);
    }

    private void readUsers(List userElements) {
        for (Element userElement : userElements) {
            String name = userElement.attributeValue("name");
            String email = userElement.attributeValue("email");
            String password = userElement.attributeValue("password");
            User user = new User(name);
            user.setEmail(email);
            user.setPassword(password);
            this.users.put(name, user);
            this.entities.add(user);
        }
    }

    private void readGroups(List groupElements) {
        for (Element groupElement : groupElements) {
            String name = groupElement.attributeValue("name");
            String type = groupElement.attributeValue("type");
            Group group = new Group(name);
            group.setType(type);
            this.entities.add(group);
            this.groups.put(name, group);
        }
    }

    private void readParentGroups(List groupElements) {
        for (Element groupElement : groupElements) {
            String childName = groupElement.attributeValue("name");
            String parentName = groupElement.attributeValue("parent");
            if (parentName == null) continue;
            Group parent = (Group)this.groups.get(parentName);
            if (parent == null) {
                throw new JbpmException("no such group: " + parentName);
            }
            Group child = (Group)this.groups.get(childName);
            parent.addChild(child);
        }
    }

    private void readMemberships(List membershipElements) {
        for (Element membershipElement : membershipElements) {
            String role = membershipElement.attributeValue("role");
            Membership membership = new Membership();
            membership.setRole(role);
            String userName = membershipElement.attributeValue("user");
            User user = (User)this.users.get(userName);
            if (user == null) {
                throw new JbpmException("no such user: " + userName);
            }
            user.addMembership(membership);
            String groupName = membershipElement.attributeValue("group");
            Group group = (Group)this.groups.get(groupName);
            if (group == null) {
                throw new JbpmException("no such group: " + groupName);
            }
            group.addMembership(membership);
            this.entities.add(membership);
        }
    }
}

