/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.identity;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jbpm.identity.Entity;
import org.jbpm.identity.Group;
import org.jbpm.identity.Membership;

public class User
extends Entity
implements Principal {
    private static final long serialVersionUID = 1L;
    protected String password = null;
    protected String email = null;
    protected Set<Membership> memberships = null;

    public User() {
    }

    public User(String name) {
        super(name);
    }

    public void addMembership(Membership membership) {
        if (this.memberships == null) {
            this.memberships = new HashSet<Membership>();
        }
        this.memberships.add(membership);
        membership.setUser(this);
    }

    public Set<Group> getGroupsForGroupType(String groupType) {
        Set<Group> groups;
        if (this.memberships != null) {
            groups = new HashSet();
            for (Membership membership : this.memberships) {
                if (!groupType.equals(membership.getGroup().getType())) continue;
                groups.add(membership.getGroup());
            }
        } else {
            groups = Collections.emptySet();
        }
        return groups;
    }

    public Set<Group> getGroupsForMembershipRole(String membershipRole) {
        Set<Group> groups;
        if (this.memberships != null) {
            groups = new HashSet();
            for (Membership membership : this.memberships) {
                if (!membershipRole.equals(membership.getRole())) continue;
                groups.add(membership.getGroup());
            }
        } else {
            groups = Collections.emptySet();
        }
        return groups;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public Set<Membership> getMemberships() {
        return this.memberships;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}

