/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.identity.hibernate;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.Permission;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionUserType
implements CompositeUserType {
    private static final String[] PROPERTY_NAMES = new String[]{"class", "name", "actions"};
    private static final Type[] PROPERTY_TYPES = new Type[]{Hibernate.STRING, Hibernate.STRING, Hibernate.STRING};
    private static final Class<?>[] NAME_ACTIOS_CONSTRUCTOR_PARAMETER_TYPES = new Class[]{String.class, String.class};

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public Type[] getPropertyTypes() {
        return PROPERTY_TYPES;
    }

    public Object getPropertyValue(Object component, int property) throws HibernateException {
        Permission permission = (Permission)component;
        if (property == 0) {
            return permission.getClass().getName();
        }
        if (property == 1) {
            return permission.getName();
        }
        if (property == 2) {
            return permission.getActions();
        }
        throw new IllegalArgumentException("illegal permission property '" + property + "'");
    }

    public void setPropertyValue(Object component, int property, Object value) throws HibernateException {
        throw new UnsupportedOperationException("setting properties on a permission is not allowed");
    }

    public Class<?> returnedClass() {
        return Permission.class;
    }

    public boolean equals(Object left, Object right) throws HibernateException {
        return left.equals(right);
    }

    public int hashCode(Object permission) throws HibernateException {
        return permission.hashCode();
    }

    public Object nullSafeGet(ResultSet resultSet, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Permission permission = null;
        String className = resultSet.getString(names[0]);
        String name = resultSet.getString(names[1]);
        String actions = resultSet.getString(names[2]);
        try {
            ClassLoader classLoader = PermissionUserType.class.getClassLoader();
            Class<Permission> permissionClass = Class.forName(className, false, classLoader).asSubclass(Permission.class);
            Constructor<Permission> constructor = permissionClass.getDeclaredConstructor(NAME_ACTIOS_CONSTRUCTOR_PARAMETER_TYPES);
            permission = constructor.newInstance(name, actions);
        }
        catch (Exception e) {
            throw new HibernateException("couldn't create permission from database record [" + className + "|" + name + "|" + actions + "].  Does the permission class have a (String name,String actions) constructor ?", (Throwable)e);
        }
        return permission;
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        Permission permission = (Permission)value;
        preparedStatement.setString(index, permission.getClass().getName());
        preparedStatement.setString(index + 1, permission.getName());
        preparedStatement.setString(index + 2, permission.getActions());
    }

    public Object deepCopy(Object permission) throws HibernateException {
        return permission;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, SessionImplementor session, Object owner) throws HibernateException {
        return original;
    }
}

