/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.runtime;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.bpm.api.NotImplementedException;
import org.jboss.bpm.api.runtime.Attachments;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.integration.spec.runtime.TokenImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenAttachmentDelegate
implements Attachments {
    private ContextInstance context;
    private TokenImpl token;

    public TokenAttachmentDelegate(TokenImpl token, ContextInstance context) {
        this.token = token;
        this.context = context;
    }

    public <T> T addAttachment(Class<T> clazz, Object value) {
        return this.addAttachment(clazz, null, value);
    }

    public Object addAttachment(String name, Object value) {
        return this.addAttachment(null, name, value);
    }

    public <T> T addAttachment(Class<T> clazz, String name, Object value) {
        this.validateAttachmentKey(clazz, name);
        this.context.createVariable(name, value, (Token)this.token.getDelegate());
        return (T)value;
    }

    public <T> T getAttachment(Class<T> clazz) {
        return this.getAttachment(clazz, null);
    }

    public Object getAttachment(String name) {
        return this.getAttachment(null, name);
    }

    public <T> T getAttachment(Class<T> clazz, String name) {
        this.validateAttachmentKey(clazz, name);
        return (T)this.context.getVariable(name, (Token)this.token.getDelegate());
    }

    public Collection<Attachments.Key> getAttachmentKeys() {
        HashSet<Attachments.Key> keys = new HashSet<Attachments.Key>();
        Set strKeys = this.context.getVariables((Token)this.token.getDelegate()).keySet();
        for (String strKey : strKeys) {
            Attachments.Key key = new Attachments.Key(null, strKey);
            keys.add(key);
        }
        return keys;
    }

    public <T> T removeAttachment(Class<T> clazz, String name) {
        T value = this.getAttachment(clazz, name);
        this.context.deleteVariable(name, (Token)this.token.getDelegate());
        return value;
    }

    public <T> T removeAttachment(Class<T> clazz) {
        return this.removeAttachment(clazz, null);
    }

    public Object removeAttachment(String name) {
        return this.removeAttachment(null, name);
    }

    private <T> void validateAttachmentKey(Class<T> clazz, String name) {
        if (clazz != null) {
            throw new NotImplementedException("Attachments keyed by Class not supported");
        }
        if (name == null) {
            throw new NotImplementedException("Attachments with null name not supported");
        }
    }
}

