/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.ObjectName;
import org.jboss.bpm.api.runtime.Context;
import org.jboss.bpm.api.service.ContextService;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.bpm.api.service.ProcessEngineSupport;
import org.jboss.bpm.api.service.ProcessInstanceService;
import org.jboss.bpm.api.service.internal.AbstractProcessDefinitionService;
import org.jbpm.JbpmContext;
import org.jbpm.db.GraphSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.integration.spec.model.ProcessDefinitionImpl;
import org.jbpm.integration.spec.runtime.InvocationProxy;
import org.jbpm.integration.spec.service.MutableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessDefinitionServiceImpl
extends AbstractProcessDefinitionService
implements MutableService {
    static final Logger log = LoggerFactory.getLogger(ProcessDefinitionServiceImpl.class);

    @Override
    public void setProcessEngine(ProcessEngine engine) {
        super.setProcessEngine(engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.jboss.bpm.api.model.ProcessDefinition getProcessDefinition(ObjectName procDefID) {
        ContextService ctxService = (ContextService)this.getProcessEngine().getService(ContextService.class);
        Context bpmContext = ctxService.getContext(true);
        try {
            org.jboss.bpm.api.model.ProcessDefinition procDef = null;
            GraphSession graphSession = ((JbpmContext)bpmContext.getAttachment(JbpmContext.class)).getGraphSession();
            ProcessDefinition oldProcDef = graphSession.getProcessDefinition(this.adaptKey(procDefID).longValue());
            if (oldProcDef != null) {
                procDef = ProcessDefinitionImpl.newInstance(this.getProcessEngine(), oldProcDef, true);
            }
            org.jboss.bpm.api.model.ProcessDefinition processDefinition = procDef;
            return processDefinition;
        }
        finally {
            bpmContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ObjectName> getProcessDefinitions() {
        ContextService ctxService = (ContextService)this.getProcessEngine().getService(ContextService.class);
        Context bpmContext = ctxService.getContext(true);
        try {
            HashSet<ObjectName> procDefs = new HashSet<ObjectName>();
            GraphSession graphSession = ((JbpmContext)bpmContext.getAttachment(JbpmContext.class)).getGraphSession();
            Iterator i$ = graphSession.findAllProcessDefinitions().iterator();
            while (i$.hasNext()) {
                ProcessDefinition item;
                ProcessDefinition oldProcDef = item = (ProcessDefinition)i$.next();
                procDefs.add(ProcessDefinitionImpl.getKey(oldProcDef));
            }
            Set<ObjectName> set = Collections.unmodifiableSet(procDefs);
            return set;
        }
        finally {
            bpmContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.jboss.bpm.api.model.ProcessDefinition registerProcessDefinition(org.jboss.bpm.api.model.ProcessDefinition procDef) {
        ContextService ctxService = (ContextService)this.getProcessEngine().getService(ContextService.class);
        Context bpmContext = ctxService.getContext(true);
        try {
            log.debug("registerProcessDefinition: " + procDef);
            if (this.getProcessDefinition(procDef.getKey()) != null) {
                throw new IllegalStateException("Process definition already registered: " + procDef);
            }
            JbpmContext jbpmContext = (JbpmContext)bpmContext.getAttachment(JbpmContext.class);
            ProcessDefinitionImpl procDefImpl = InvocationProxy.getUnderlying(procDef, ProcessDefinitionImpl.class);
            jbpmContext.deployProcessDefinition((ProcessDefinition)procDefImpl.getDelegate());
            org.jboss.bpm.api.model.ProcessDefinition processDefinition = procDef = InvocationProxy.newInstance((ProcessEngineSupport)procDefImpl, org.jboss.bpm.api.model.ProcessDefinition.class);
            return processDefinition;
        }
        finally {
            bpmContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterProcessDefinition(ObjectName procDefID) {
        boolean removed = false;
        ContextService ctxService = (ContextService)this.getProcessEngine().getService(ContextService.class);
        Context bpmContext = ctxService.getContext(true);
        try {
            org.jboss.bpm.api.model.ProcessDefinition procDef = this.getProcessDefinition(procDefID);
            if (procDef != null) {
                log.debug("unregisterProcessDefinition: " + procDef);
                ProcessInstanceService procService = (ProcessInstanceService)this.getProcessEngine().getService(ProcessInstanceService.class);
                for (ObjectName procID : procService.getInstance(procDefID, null)) {
                    procService.unregisterInstance(procID);
                }
                JbpmContext jbpmContext = (JbpmContext)bpmContext.getAttachment(JbpmContext.class);
                jbpmContext.getGraphSession().deleteProcessDefinition(this.adaptKey(procDefID).longValue());
                removed = true;
            }
        }
        finally {
            bpmContext.close();
        }
        return removed;
    }

    private Long adaptKey(ObjectName key) {
        String id = key.getKeyProperty("id");
        if (id == null) {
            throw new IllegalStateException("Cannot obtain id property from: " + key);
        }
        return new Long(id);
    }
}

