/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.model;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.jboss.bpm.api.model.Node;
import org.jboss.bpm.api.model.ObjectNameFactory;
import org.jboss.bpm.api.model.ProcessInstance;
import org.jboss.bpm.api.runtime.Attachments;
import org.jboss.bpm.api.runtime.Context;
import org.jboss.bpm.api.runtime.Token;
import org.jboss.bpm.api.service.ContextService;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.bpm.api.service.ProcessEngineSupport;
import org.jboss.bpm.api.service.ProcessInstanceService;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.Identifiable;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.integration.spec.model.AbstractElementImpl;
import org.jbpm.integration.spec.model.ProcessDefinitionImpl;
import org.jbpm.integration.spec.runtime.InvocationProxy;
import org.jbpm.integration.spec.runtime.TokenImpl;
import org.jbpm.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInstanceImpl
extends AbstractElementImpl<org.jbpm.graph.exe.ProcessInstance>
implements ProcessInstance {
    private static final long serialVersionUID = 1L;
    private ObjectName keyCache;

    public static ProcessInstance newInstance(ProcessEngine engine, org.jbpm.graph.exe.ProcessInstance tmpProc, boolean proxy) {
        ProcessInstanceImpl proc = new ProcessInstanceImpl(engine, tmpProc);
        if (proxy) {
            proc = InvocationProxy.newInstance((ProcessEngineSupport)proc, ProcessInstance.class);
        }
        return proc;
    }

    private ProcessInstanceImpl(ProcessEngine engine, org.jbpm.graph.exe.ProcessInstance tmpProc) {
        super(engine, (Identifiable)tmpProc, org.jbpm.graph.exe.ProcessInstance.class);
        if (tmpProc.getId() > 0L) {
            this.keyCache = ProcessInstanceImpl.getKey(tmpProc);
        }
    }

    public ObjectName getKey() {
        ObjectName objKey = this.keyCache;
        if (objKey == null) {
            org.jbpm.graph.exe.ProcessInstance delegate = (org.jbpm.graph.exe.ProcessInstance)this.getDelegate();
            objKey = ProcessInstanceImpl.getKey(delegate);
            if (delegate.getId() > 0L) {
                this.keyCache = objKey;
            }
        }
        return objKey;
    }

    public static ObjectName getKey(org.jbpm.graph.exe.ProcessInstance procInst) {
        ProcessDefinition oldProcDef = procInst.getProcessDefinition();
        return ObjectNameFactory.create((String)("jboss.jbpm:procInst=" + oldProcDef.getName() + ",id=" + procInst.getId()));
    }

    public org.jboss.bpm.api.model.ProcessDefinition getProcessDefinition() {
        ProcessDefinition oldProcDef = ((org.jbpm.graph.exe.ProcessInstance)this.getDelegate()).getProcessDefinition();
        return ProcessDefinitionImpl.newInstance(this.getProcessEngine(), oldProcDef, true);
    }

    public ProcessInstance.ProcessStatus getProcessStatus() {
        ProcessInstance.ProcessStatus status;
        Token rootToken = this.getRootToken();
        Token.TokenStatus tokenStatus = rootToken != null ? rootToken.getTokenStatus() : null;
        org.jbpm.graph.exe.ProcessInstance oldProcInst = (org.jbpm.graph.exe.ProcessInstance)this.getDelegate();
        long procID = oldProcInst.getId();
        ProcessInstance.ProcessStatus processStatus = status = procID > 0L ? ProcessInstance.ProcessStatus.Ready : ProcessInstance.ProcessStatus.None;
        if (oldProcInst.getStart() != null) {
            status = ProcessInstance.ProcessStatus.Active;
        }
        if (oldProcInst.isSuspended()) {
            status = ProcessInstance.ProcessStatus.Suspended;
        }
        if (oldProcInst.hasEnded() || tokenStatus == Token.TokenStatus.Destroyed) {
            status = ProcessInstance.ProcessStatus.Completed;
        }
        return status;
    }

    public void setProcessStatus(ProcessInstance.ProcessStatus status) {
    }

    public Token getRootToken() {
        Token token = null;
        if (((org.jbpm.graph.exe.ProcessInstance)this.getDelegate()).getRootToken() != null) {
            token = TokenImpl.newInstance(this.getProcessEngine(), ((org.jbpm.graph.exe.ProcessInstance)this.getDelegate()).getRootToken());
        }
        return token;
    }

    public String getName() {
        return this.getProcessDefinition().getName();
    }

    public Date getEndDate() {
        return ((org.jbpm.graph.exe.ProcessInstance)this.getDelegate()).getEnd();
    }

    public Date getStartDate() {
        return ((org.jbpm.graph.exe.ProcessInstance)this.getDelegate()).getStart();
    }

    public <T extends Node> T getNode(Class<T> clazz, String name) {
        return (T)this.getProcessDefinition().getNode(clazz, name);
    }

    public Node getNode(String name) {
        return this.getProcessDefinition().getNode(name);
    }

    public List<Node> getNodes() {
        return this.getProcessDefinition().getNodes();
    }

    public <T extends Node> List<T> getNodes(Class<T> clazz) {
        return this.getProcessDefinition().getNodes(clazz);
    }

    public Token startProcess() {
        return this.startProcess(null);
    }

    public Token startProcess(Attachments contextData) {
        ContextService ctxService = (ContextService)this.getProcessEngine().getService(ContextService.class);
        Context bpmContext = ctxService.getContext(true);
        try {
            ProcessInstanceService procService = (ProcessInstanceService)this.getProcessEngine().getService(ProcessInstanceService.class);
            if (procService.getInstance(this.getKey()) == null) {
                procService.registerInstance((ProcessInstance)this);
            }
            org.jbpm.graph.exe.ProcessInstance procInst = (org.jbpm.graph.exe.ProcessInstance)this.getDelegate();
            org.jbpm.graph.exe.Token rootToken = new org.jbpm.graph.exe.Token(procInst);
            procInst.setStart(Clock.getCurrentTime());
            procInst.setRootToken(rootToken);
            Token token = TokenImpl.newInstance(this.getProcessEngine(), rootToken);
            JbpmContext jbpmContext = (JbpmContext)bpmContext.getAttachment(JbpmContext.class);
            jbpmContext.getSession().save((Object)rootToken);
            if (contextData != null) {
                Attachments tokenAtt = token.getAttachments();
                for (Attachments.Key key : contextData.getAttachmentKeys()) {
                    Object val = contextData.getAttachment(key.getClassPart(), key.getNamePart());
                    tokenAtt.addAttachment(key.getClassPart(), key.getNamePart(), val);
                }
            }
            this.setProcessStatus(ProcessInstance.ProcessStatus.Active);
            procInst.fireStartEvent(rootToken.getNode());
            token.signal();
            Token token2 = token;
            return token2;
        }
        catch (RuntimeException rte) {
            this.setProcessStatus(ProcessInstance.ProcessStatus.Aborted);
            throw rte;
        }
        finally {
            bpmContext.close();
        }
    }

    public Set<Token> getTokens() {
        return this.getAllTokens(this.getRootToken());
    }

    public void suspend() {
        ProcessInstance.ProcessStatus status = this.getProcessStatus();
        if (status != ProcessInstance.ProcessStatus.Active) {
            throw new IllegalStateException("Cannot suspend a process in state: " + status);
        }
        ((org.jbpm.graph.exe.ProcessInstance)this.getDelegate()).suspend();
    }

    public void resume() {
        ProcessInstance.ProcessStatus status = this.getProcessStatus();
        if (status != ProcessInstance.ProcessStatus.Suspended) {
            throw new IllegalStateException("Cannot resume a process in state: " + status);
        }
        ((org.jbpm.graph.exe.ProcessInstance)this.getDelegate()).resume();
    }

    public void cancel() {
        ProcessInstance.ProcessStatus status = this.getProcessStatus();
        if (status != ProcessInstance.ProcessStatus.Active && status != ProcessInstance.ProcessStatus.Suspended) {
            throw new IllegalStateException("Cannot cancel a process in state: " + status);
        }
        org.jbpm.graph.exe.ProcessInstance delegate = (org.jbpm.graph.exe.ProcessInstance)this.getDelegate();
        delegate.setEnd(new Date());
        delegate.end();
    }

    private Set<Token> getAllTokens(Token token) {
        HashSet<Token> tokens = new HashSet<Token>();
        if (token != null) {
            tokens.add(token);
            for (Token childToken : token.getChildTokens()) {
                tokens.addAll(this.getAllTokens(childToken));
            }
        }
        return tokens;
    }

    public String toString() {
        return "ProcessInstance[" + this.getKey() + ",status=" + this.getProcessStatus() + "]";
    }
}

