/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.spec.task;

import java.util.HashSet;
import java.util.Set;
import javax.management.ObjectName;
import org.jboss.bpm.api.model.ObjectNameFactory;
import org.jboss.bpm.api.runtime.Token;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.bpm.api.service.ProcessEngineSupport;
import org.jboss.bpm.api.service.TokenService;
import org.jbpm.graph.def.Identifiable;
import org.jbpm.integration.spec.model.AbstractElementImpl;
import org.jbpm.integration.spec.runtime.InvocationProxy;
import org.jbpm.integration.spec.runtime.TokenImpl;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskInstanceImpl
extends AbstractElementImpl<TaskInstance>
implements org.jboss.bpm.incubator.task.TaskInstance {
    private static final long serialVersionUID = 1L;
    final Logger log = LoggerFactory.getLogger(TaskInstanceImpl.class);
    private ObjectName keyCache;

    public static org.jboss.bpm.incubator.task.TaskInstance newInstance(ProcessEngine engine, TaskInstance tmpTask) {
        return InvocationProxy.newInstance((ProcessEngineSupport)new TaskInstanceImpl(engine, tmpTask), org.jboss.bpm.incubator.task.TaskInstance.class);
    }

    private TaskInstanceImpl(ProcessEngine engine, TaskInstance tmpTask) {
        super(engine, (Identifiable)tmpTask, TaskInstance.class);
        if (tmpTask.getId() > 0L) {
            this.keyCache = TaskInstanceImpl.getKey(tmpTask);
        }
    }

    public ObjectName getKey() {
        ObjectName objKey = this.keyCache;
        if (objKey == null) {
            TaskInstance delegate = (TaskInstance)this.getDelegate();
            objKey = TaskInstanceImpl.getKey(delegate);
            if (delegate.getId() > 0L) {
                this.keyCache = objKey;
            }
        }
        return objKey;
    }

    public static ObjectName getKey(TaskInstance tmpTask) {
        return ObjectNameFactory.create((String)("Task:id=" + tmpTask.getId()));
    }

    public String getName() {
        return ((TaskInstance)this.getDelegate()).getName();
    }

    public void end(String targetName) {
        ((TaskInstance)this.getDelegate()).end(targetName);
    }

    public boolean hasEnded() {
        return ((TaskInstance)this.getDelegate()).hasEnded();
    }

    public boolean isCancelled() {
        return ((TaskInstance)this.getDelegate()).isCancelled();
    }

    public boolean isBlocking() {
        return ((TaskInstance)this.getDelegate()).isBlocking();
    }

    public boolean isSignalling() {
        return ((TaskInstance)this.getDelegate()).isSignalling();
    }

    public String getActor() {
        return ((TaskInstance)this.getDelegate()).getActorId();
    }

    public ObjectName getCorrelationKey() {
        Token token = null;
        if (((TaskInstance)this.getDelegate()).getToken() != null) {
            long tokenID = ((TaskInstance)this.getDelegate()).getToken().getId();
            TokenService exService = (TokenService)this.getProcessEngine().getService(TokenService.class);
            for (Token auxTok : exService.getTokens()) {
                TokenImpl tokenImpl = InvocationProxy.getUnderlying(auxTok, TokenImpl.class);
                if (((org.jbpm.graph.exe.Token)tokenImpl.getDelegate()).getId() != tokenID) continue;
                token = auxTok;
                break;
            }
        }
        if (token == null) {
            throw new IllegalStateException("Cannot obtain associated token");
        }
        return token.getKey();
    }

    public Set<String> getPooledActors() {
        HashSet<String> actors = new HashSet<String>();
        for (PooledActor pa : ((TaskInstance)this.getDelegate()).getPooledActors()) {
            actors.add(pa.getActorId());
        }
        return actors;
    }
}

