/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.integration.client;

// $Id: ExecutionManagerImpl.java 2018 2008-08-26 15:23:39Z thomas.diesler@jboss.com $

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.client.ExecutionManager;
import org.jboss.bpm.client.SignalManager;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.Signal;
import org.jboss.bpm.model.StartEvent;
import org.jboss.bpm.model.Process.ProcessStatus;
import org.jboss.bpm.model.Signal.SignalType;
import org.jboss.bpm.runtime.Attachments;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.Execution;
import org.jbpm.integration.model.ProcessImpl;

/**
 * The process manager is the entry point to create, find and otherwise manage processes.
 * 
 * @author thomas.diesler@jboss.com
 * @since 26-Aug-2008
 */
public class ExecutionManagerImpl extends ExecutionManager
{
  // provide logging
  private static final Log log = LogFactory.getLog(ExecutionManagerImpl.class);

  @Override
  public void startProcess(Process proc, Attachments att)
  {
    ProcessImpl procImpl = (ProcessImpl)proc;
    procImpl.setProcessStatus(ProcessStatus.Active);
    ProcessDefinition jbpmProc = procImpl.getProcessDefinition();

    SignalManager sigManager = SignalManager.locateSignalManager();
    sigManager.throwSignal(new Signal(proc.getID(), SignalType.SYSTEM_PROCESS_ENTER));
    try
    {
      Execution jbpmEx = new Execution(jbpmProc);
      while (jbpmEx.hasEnded() == false)
      {
        jbpmEx.signal();
      }
    }
    finally
    {
      sigManager.throwSignal(new Signal(proc.getID(), SignalType.SYSTEM_PROCESS_EXIT));
    }
    procImpl.setProcessStatus(ProcessStatus.Completed);
  }

  @Override
  public ProcessStatus waitForEnd(Process proc)
  {
    return proc.getProcessStatus();
  }

  @Override
  public ProcessStatus waitForEnd(Process proc, long timeout)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  @Override
  public void startProcess(StartEvent start, Attachments att)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }
}