/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.integration.client;

// $Id: MessageManagerImpl.java 2018 2008-08-26 15:23:39Z thomas.diesler@jboss.com $

import javax.management.ObjectName;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.client.MessageManager;
import org.jboss.bpm.model.Event;
import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.Task;

/**
 * The ProcessEngine sends mesages through the MessageManager. 
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Jun-2008
 */
public class MessageManagerImpl extends MessageManager
{
  // provide logging
  private static final Log log = LogFactory.getLog(MessageManagerImpl.class);
  
  /**
   * Send a message to a given {@link Task} or {@link Event}
   */
  @Override
  public void sendMessage(ObjectName procID, String targetName, Message msg)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }
}