/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.integration.model;

//$Id: ProcessImpl.java 2018 2008-08-26 15:23:39Z thomas.diesler@jboss.com $

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.management.ObjectName;

import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.client.ExecutionManager;
import org.jboss.bpm.model.Assignment;
import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.InputSet;
import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.ObjectNameFactory;
import org.jboss.bpm.model.OutputSet;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.Property;
import org.jboss.bpm.model.SequenceFlow;
import org.jboss.bpm.runtime.Attachments;
import org.jboss.util.id.UID;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;

/**
 * A Process is any Activity performed within a company or organization.
 * 
 * @author thomas.diesler@jboss.com
 * @since 26-Aug-2008
 */
@SuppressWarnings("serial")
public class ProcessImpl extends AbstractElementImpl implements Process
{
  private ProcessDefinition jbpmProc;
  private List<FlowObject> flowObjects = new ArrayList<FlowObject>();
  private ProcessStatus status = ProcessStatus.None;

  public ProcessImpl(ProcessDefinition jbpmProc)
  {
    this.jbpmProc = jbpmProc;
  }

  public ProcessDefinition getProcessDefinition()
  {
    return jbpmProc;
  }

  public ObjectName getID()
  {
    if (id == null)
    {
      StringBuilder str = new StringBuilder("org.jbpm:");
      str.append("type=Process,name=" + getName() + ",id=" + new UID());
      id = ObjectNameFactory.create(str.toString());
    }
    return id;
  }

  public String getName()
  {
    return jbpmProc.getName();
  }
  
  public ProcessStatus getProcessStatus()
  {
    return status;
  }

  public void setProcessStatus(ProcessStatus status)
  {
    this.status = status;
  }

  public void addFlowObject(FlowObject flowObject)
  {
    flowObjects.add(flowObject);
  }

  public ObjectName startProcess()
  {
    ExecutionManager exManager = ExecutionManager.locateExecutionManager();
    exManager.startProcess(this, null);
    return getID();
  }

  public ProcessStatus waitForEnd()
  {
    ExecutionManager exManager = ExecutionManager.locateExecutionManager();
    return exManager.waitForEnd(this);
  }
  
  public ProcessStatus waitForEnd(long timeout)
  {
    ExecutionManager exManager = ExecutionManager.locateExecutionManager();
    return exManager.waitForEnd(this, timeout);
  }

  public List<FlowObject> getFlowObjects()
  {
    return Collections.unmodifiableList(flowObjects);
  }

  public FlowObject getFlowObject(String name)
  {
    for (FlowObject fo : getFlowObjects())
    {
      if (name.equals(fo.getName()))
        return fo;
    }
    return null;
  }

  public void initialize()
  {
    for (FlowObject fo : getFlowObjects())
    {
      FlowObjectImpl foImpl = (FlowObjectImpl)fo;
      SequenceFlowImpl flowImpl = (SequenceFlowImpl)foImpl.getOutFlow();
      if (flowImpl != null)
      {
        String targetName = flowImpl.getTargetName();
        FlowObjectImpl targetFO = (FlowObjectImpl)getFlowObject(targetName);
        Node jbpmTarget = targetFO.getNode();
        Transition jbpmTransition = flowImpl.getTransition();
        jbpmTransition.setTo(jbpmTarget);
      }
    }
  }

  // not implemented *******************************************************************
  
  public List<Assignment> getAssignments()
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public <T extends FlowObject> List<T> getFlowObjects(Class<T> clazz)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public List<InputSet> getInputSets()
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public Message getMessage(String msgName)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public List<Message> getMessages()
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public List<OutputSet> getOutputSets()
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public List<String> getPerformers()
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public ProcessType getProcessType()
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public ObjectName startProcess(Attachments att)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public List<Property> getProperties()
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public Property getProperty(String name)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public List<String> getPropertyNames()
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public Object getPropertyValue(String name)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public <T> T getPropertyValue(Class<T> clazz, String name)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

}