/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.integration.model;

//$Id: SequenceFlowImpl.java 2018 2008-08-26 15:23:39Z thomas.diesler@jboss.com $

import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.model.Expression;
import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.SequenceFlow;
import org.jbpm.graph.def.Transition;

/**
 * A Sequence Flow is used to show the order that activities will be performed in a Process. 
 * 
 * @author thomas.diesler@jboss.com
 * @since 26-Aug-2008
 */
public class SequenceFlowImpl implements SequenceFlow
{
  private Transition jbpmTransition;
  
  public SequenceFlowImpl(Transition jbpmTransition)
  {
    this.jbpmTransition = jbpmTransition;
  }

  public Transition getTransition()
  {
    return jbpmTransition;
  }

  public String getName()
  {
    return jbpmTransition.getName();
  }

  public String getTargetName()
  {
    return jbpmTransition.getName();
  }
  
  public Expression getConditionExpression()
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public ConditionType getConditionType()
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public FlowObject getSourceRef()
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public FlowObject getTargetRef()
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }
}