/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.integration.model;

//$Id: StateWrapper.java 2030 2008-08-27 10:15:00Z thomas.diesler@jboss.com $

import org.jboss.bpm.client.SignalManager;
import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.Signal;
import org.jboss.bpm.model.Signal.SignalType;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.node.State;

/**
 * Override Node methods for signal processing
 * 
 * @author thomas.diesler@jboss.com
 * @since 26-Aug-2008
 */
@SuppressWarnings("serial")
public class StateWrapper extends State implements NodeWrapper
{
  private FlowObject flowObject;
  
  public StateWrapper(String name)
  {
    super(name);
  }

  public FlowObject getFlowObject()
  {
    return flowObject;
  }

  public void setFlowObject(FlowObject flowObject)
  {
    this.flowObject = flowObject;
  }
  
  @Override
  public void execute(ExecutionContext executionContext)
  {
    SignalManager sigManager = SignalManager.locateSignalManager();
    sigManager.throwSignal(new Signal(flowObject.getID(), SignalType.SYSTEM_TASK_ENTER));
    try
    {
      super.execute(executionContext);
    }
    finally
    {
      sigManager.throwSignal(new Signal(flowObject.getID(), SignalType.SYSTEM_TASK_EXIT));
    }
  }
}