/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.calendar;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jbpm.JbpmConfiguration;
import org.jbpm.calendar.Day;
import org.jbpm.calendar.DayPart;
import org.jbpm.calendar.Duration;
import org.jbpm.calendar.Holiday;
import org.jbpm.util.ClassLoaderUtil;

public class BusinessCalendar
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Day[] weekDays;
    private final List holidays;
    private static final Map propertiesByResource = new HashMap();

    public static Properties getBusinessCalendarProperties() {
        String calendarResource = JbpmConfiguration.Configs.getString("resource.business.calendar");
        return BusinessCalendar.getBusinessCalendarProperties(calendarResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getBusinessCalendarProperties(String calendarResource) {
        Map map = propertiesByResource;
        synchronized (map) {
            Properties properties = (Properties)propertiesByResource.get(calendarResource);
            if (properties == null) {
                properties = ClassLoaderUtil.getProperties(calendarResource);
                propertiesByResource.put(calendarResource, properties);
            }
            return properties;
        }
    }

    public BusinessCalendar() {
        this(BusinessCalendar.getBusinessCalendarProperties());
    }

    public BusinessCalendar(String calendarResource) {
        this(BusinessCalendar.getBusinessCalendarProperties(calendarResource));
    }

    public BusinessCalendar(Properties calendarProperties) {
        this.weekDays = Day.parseWeekDays(calendarProperties, this);
        this.holidays = Holiday.parseHolidays(calendarProperties, this);
    }

    public Day[] getWeekDays() {
        return this.weekDays;
    }

    public List getHolidays() {
        return this.holidays;
    }

    public Date add(Date date, Duration duration) {
        Date end = null;
        if (duration.isBusinessTime()) {
            DayPart dayPart = this.findDayPart(date);
            if (dayPart == null) {
                Day day = this.findDay(date);
                dayPart = duration.isNegative() ? day.findPreviousDayPart(date) : day.findNextDayPart(date);
            }
            end = dayPart.add(date, duration);
        } else {
            end = duration.addTo(date);
        }
        return end;
    }

    public Date findStartOfNextDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        while (this.isHoliday(date)) {
            calendar.setTime(date);
            calendar.add(5, 1);
            date = calendar.getTime();
        }
        return date;
    }

    Date findEndOfPreviousDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        calendar.set(11, 23);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        while (this.isHoliday(date)) {
            calendar.setTime(date);
            calendar.add(5, -1);
            date = calendar.getTime();
        }
        return date;
    }

    public Day findDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return this.getWeekDays()[calendar.get(7)];
    }

    public boolean isHoliday(Date date) {
        Iterator iter = this.getHolidays().iterator();
        while (iter.hasNext()) {
            Holiday holiday = (Holiday)iter.next();
            if (!holiday.includes(date)) continue;
            return true;
        }
        return false;
    }

    private DayPart findDayPart(Date date) {
        if (!this.isHoliday(date)) {
            Day day = this.findDay(date);
            for (int i = 0; i < day.dayParts.length; ++i) {
                DayPart dayPart = day.dayParts[i];
                if (!dayPart.includes(date)) continue;
                return dayPart;
            }
        }
        return null;
    }

    public DayPart findNextDayPart(Date date) {
        DayPart nextDayPart = this.findDayPart(date);
        if (nextDayPart == null) {
            date = this.findStartOfNextDay(date);
            Day day = this.findDay(date);
            nextDayPart = day.findNextDayPart(date);
        }
        return nextDayPart;
    }

    public boolean isInBusinessHours(Date date) {
        return this.findDayPart(date) != null;
    }

    public static Calendar getCalendar() {
        return Calendar.getInstance();
    }
}

