/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.command.AbstractBaseCommand;
import org.jbpm.db.JobSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.job.Job;

public class ExecuteJobsCommand
extends AbstractBaseCommand {
    private static final long serialVersionUID = -2457066688404533959L;
    private static final Log log = LogFactory.getLog((Class)ExecuteJobsCommand.class);
    private transient JbpmContext jbpmContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(JbpmContext jbpmContext) throws Exception {
        this.jbpmContext = jbpmContext;
        try {
            Collection acquiredJobs = this.acquireJobs();
            Iterator i = acquiredJobs.iterator();
            while (i.hasNext()) {
                Job job = (Job)i.next();
                this.executeJob(job);
            }
        }
        finally {
            this.jbpmContext = null;
        }
        return null;
    }

    private String getName() {
        return this.toString();
    }

    protected Collection acquireJobs() {
        List jobs;
        block12: {
            boolean debug = log.isDebugEnabled();
            try {
                String lockOwner = this.getName();
                JobSession jobSession = this.jbpmContext.getJobSession();
                Job firstJob = jobSession.getFirstAcquirableJob(lockOwner);
                if (firstJob != null) {
                    if (firstJob.isExclusive()) {
                        ProcessInstance processInstance = firstJob.getProcessInstance();
                        jobs = jobSession.findExclusiveJobs(lockOwner, processInstance);
                        if (debug) {
                            log.debug((Object)("acquiring exclusive " + jobs + " for " + processInstance));
                        }
                    } else {
                        jobs = Collections.singletonList(firstJob);
                        if (debug) {
                            log.debug((Object)("acquiring " + firstJob));
                        }
                    }
                    Date lockTime = new Date();
                    Iterator i = jobs.iterator();
                    while (i.hasNext()) {
                        Job job = (Job)i.next();
                        job.setLockOwner(lockOwner);
                        job.setLockTime(lockTime);
                        if (job.getException() == null) {
                            job.setRetries(3);
                            continue;
                        }
                        int retries = job.getRetries() - 1;
                        job.setRetries(retries);
                        if (!debug) continue;
                        log.debug((Object)(job + " has " + retries + " retries remaining"));
                    }
                    if (debug) {
                        log.debug((Object)("acquired " + jobs));
                    }
                } else {
                    jobs = Collections.EMPTY_LIST;
                    if (debug) {
                        log.debug((Object)"no acquirable job found");
                    }
                }
            }
            catch (RuntimeException e) {
                jobs = Collections.EMPTY_LIST;
                if (!debug) break block12;
                log.debug((Object)"failed to acquire jobs", (Throwable)e);
            }
        }
        return jobs;
    }

    protected void executeJob(Job job) throws Exception {
        JobSession jobSession = this.jbpmContext.getJobSession();
        jobSession.reattachJob(job);
        this.jbpmContext.addAutoSaveProcessInstance(job.getProcessInstance());
        if (log.isDebugEnabled()) {
            log.debug((Object)("executing " + job));
        }
        if (job.execute(this.jbpmContext)) {
            jobSession.deleteJob(job);
        }
    }

    protected Date getNextDueDate() {
        Date nextDueDate = null;
        JobSession jobSession = this.jbpmContext.getJobSession();
        Job job = jobSession.getFirstDueJob(this.getName(), new ArrayList());
        if (job != null) {
            nextDueDate = job.getDueDate();
        }
        return nextDueDate;
    }
}

