/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.configuration.AbstractObjectInfo;
import org.jbpm.configuration.ConfigurationException;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.context.exe.Converter;
import org.jbpm.context.exe.JbpmType;
import org.jbpm.context.exe.JbpmTypeMatcher;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.db.hibernate.Converters;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class JbpmTypeObjectInfo
extends AbstractObjectInfo {
    private static final long serialVersionUID = 1L;
    private final ObjectInfo typeMatcherObjectInfo;
    private final Converter converter;
    private final Class variableInstanceClass;
    private static final Log log = LogFactory.getLog((Class)JbpmTypeObjectInfo.class);

    public JbpmTypeObjectInfo(Element jbpmTypeElement, ObjectFactoryParser objectFactoryParser) {
        super(jbpmTypeElement, objectFactoryParser);
        Class referencedClass;
        Element variableInstanceElement = XmlUtil.element(jbpmTypeElement, "variable-instance");
        if (!variableInstanceElement.hasAttribute("class")) {
            throw new ConfigurationException("missing class attribute in variable-instance");
        }
        String variableInstanceClassName = variableInstanceElement.getAttribute("class");
        try {
            referencedClass = ClassLoaderUtil.classForName(variableInstanceClassName);
        }
        catch (ClassNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("variable instance class not found: " + variableInstanceClassName));
            }
            referencedClass = null;
        }
        if (referencedClass != null) {
            if (!VariableInstance.class.isAssignableFrom(referencedClass)) {
                throw new ConfigurationException(variableInstanceClassName + " is not a variable instance");
            }
            this.variableInstanceClass = referencedClass;
            Element typeMatcherElement = XmlUtil.element(jbpmTypeElement, "matcher");
            if (typeMatcherElement == null) {
                throw new ConfigurationException("missing matcher element in jbpm-type");
            }
            Element typeMatcherBeanElement = XmlUtil.element(typeMatcherElement);
            this.typeMatcherObjectInfo = objectFactoryParser.parse(typeMatcherBeanElement);
            Element converterElement = XmlUtil.element(jbpmTypeElement, "converter");
            if (converterElement != null) {
                if (!converterElement.hasAttribute("class")) {
                    throw new ConfigurationException("missing class attribute in converter");
                }
                String converterClassName = converterElement.getAttribute("class");
                this.converter = Converters.getConverterByClassName(converterClassName);
            } else {
                this.converter = null;
            }
        } else {
            this.variableInstanceClass = null;
            this.typeMatcherObjectInfo = null;
            this.converter = null;
        }
    }

    public Object createObject(ObjectFactoryImpl objectFactory) {
        JbpmTypeMatcher jbpmTypeMatcher = this.typeMatcherObjectInfo == null ? NoTypeMatcher.INSTANCE : (JbpmTypeMatcher)objectFactory.getObject(this.typeMatcherObjectInfo);
        return new JbpmType(jbpmTypeMatcher, this.converter, this.variableInstanceClass);
    }

    private static class NoTypeMatcher
    implements JbpmTypeMatcher {
        static final JbpmTypeMatcher INSTANCE = new NoTypeMatcher();
        private static final long serialVersionUID = 1L;

        private NoTypeMatcher() {
        }

        public boolean matches(Object value) {
            return false;
        }
    }
}

