/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.context.exe;

import java.io.Serializable;
import java.util.Iterator;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.Converter;
import org.jbpm.context.exe.JbpmType;
import org.jbpm.context.exe.TokenVariableMap;
import org.jbpm.context.exe.converter.SerializableToByteArrayConverter;
import org.jbpm.context.exe.variableinstance.NullInstance;
import org.jbpm.context.exe.variableinstance.UnpersistableInstance;
import org.jbpm.context.log.VariableCreateLog;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.util.ClassUtil;

public abstract class VariableInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    long id;
    int version;
    protected String name;
    protected Token token;
    protected TokenVariableMap tokenVariableMap;
    protected ProcessInstance processInstance;
    protected Converter converter;
    protected Object valueCache;
    protected boolean isValueCached;

    public static VariableInstance create(Token token, String name, Object value) {
        VariableInstance variableInstance = value != null ? VariableInstance.createVariableInstance(value) : new NullInstance();
        variableInstance.name = name;
        if (token != null) {
            variableInstance.token = token;
            variableInstance.processInstance = token.getProcessInstance();
            token.addLog(new VariableCreateLog(variableInstance));
        }
        variableInstance.setValue(value);
        return variableInstance;
    }

    public static VariableInstance createVariableInstance(Object value) {
        Iterator iter = JbpmType.getJbpmTypes().iterator();
        while (iter.hasNext()) {
            JbpmType jbpmType = (JbpmType)iter.next();
            if (!jbpmType.matches(value)) continue;
            return jbpmType.newVariableInstance();
        }
        return new UnpersistableInstance();
    }

    public abstract boolean isStorable(Object var1);

    protected abstract Object getObject();

    protected abstract void setObject(Object var1);

    public boolean supports(Object value) {
        if (this.converter != null) {
            return this.converter.supports(value);
        }
        return this.isStorable(value);
    }

    public void setValue(Object value) {
        this.valueCache = value;
        this.isValueCached = true;
        if (this.converter != null) {
            if (!this.converter.supports(value)) {
                throw new JbpmException("converter " + this.converter.getClass().getName() + " does not support value: " + value);
            }
            value = this.converter.convert(value);
        }
        if (value != null && !this.isStorable(value)) {
            throw new JbpmException(this + " cannot store values of type " + value.getClass().getName());
        }
        this.setObject(value);
    }

    public Object getValue() {
        if (this.isValueCached) {
            return this.valueCache;
        }
        Object value = this.getObject();
        if (value != null && this.converter != null) {
            if (this.converter instanceof SerializableToByteArrayConverter && this.processInstance != null) {
                SerializableToByteArrayConverter s2bConverter = (SerializableToByteArrayConverter)this.converter;
                value = s2bConverter.revert(value, this.processInstance.getProcessDefinition());
            } else {
                value = this.converter.revert(value);
            }
            this.valueCache = value;
            this.isValueCached = true;
        }
        return value;
    }

    public void removeReferences() {
        this.tokenVariableMap = null;
        this.token = null;
        this.processInstance = null;
    }

    public String toString() {
        return ClassUtil.getSimpleName(this.getClass()) + '(' + this.name + ')';
    }

    public String getName() {
        return this.name;
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public Token getToken() {
        return this.token;
    }

    public void setTokenVariableMap(TokenVariableMap tokenVariableMap) {
        this.tokenVariableMap = tokenVariableMap;
    }
}

