/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jcr.impl;

import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.jbpm.JbpmException;
import org.jbpm.jcr.impl.JcrServiceImpl;
import org.jbpm.svc.Service;
import org.jbpm.svc.ServiceFactory;

public abstract class AbstractJcrServiceFactory
implements ServiceFactory {
    private static final long serialVersionUID = 1L;
    String username;
    String password;
    String workspace;

    public Service openService() {
        try {
            Repository jcrRepository = this.getRepository();
            Session session = this.username == null && this.workspace == null ? jcrRepository.login() : (this.username == null ? jcrRepository.login(this.workspace) : (this.workspace == null ? jcrRepository.login(this.getCredentials()) : jcrRepository.login(this.getCredentials(), this.workspace)));
            return new JcrServiceImpl(session);
        }
        catch (Exception e) {
            throw new JbpmException("could not login to jcr repository as user " + this.username + " in workspace " + this.workspace, e);
        }
    }

    Credentials getCredentials() {
        char[] pwdChars = this.password != null ? this.password.toCharArray() : null;
        return new SimpleCredentials(this.username, pwdChars);
    }

    protected abstract Repository getRepository();

    public void close() {
    }
}

