/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job.executor;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.job.Job;
import org.jbpm.job.executor.Deactivable;
import org.jbpm.job.executor.JobExecutor;

class DispatcherThread
extends Thread
implements Deactivable {
    private final JobExecutor jobExecutor;
    private volatile boolean active = true;
    static final String DEFAULT_NAME = "Dispatcher";
    private static final Log log = LogFactory.getLog((Class)DispatcherThread.class);

    DispatcherThread(JobExecutor jobExecutor) {
        this(DEFAULT_NAME, jobExecutor);
    }

    DispatcherThread(String name, JobExecutor jobExecutor) {
        super(jobExecutor.getThreadGroup(), name);
        this.jobExecutor = jobExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int retryInterval = this.jobExecutor.getRetryInterval();
        while (this.active) {
            Job job = this.acquireJob();
            if (job != null) {
                this.submitJob(job);
            }
            if (!this.active) continue;
            try {
                if (job != null) {
                    retryInterval = this.jobExecutor.getRetryInterval();
                    long waitPeriod = this.getWaitPeriod(this.jobExecutor.getIdleInterval());
                    if (waitPeriod <= 0L) continue;
                    JobExecutor jobExecutor = this.jobExecutor;
                    synchronized (jobExecutor) {
                        this.jobExecutor.wait(waitPeriod);
                        continue;
                    }
                }
                DispatcherThread.sleep(retryInterval);
                int maxIdleInterval = this.jobExecutor.getMaxIdleInterval();
                if ((retryInterval *= 2) <= maxIdleInterval && retryInterval >= 0) continue;
                retryInterval = maxIdleInterval;
            }
            catch (InterruptedException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(this.getName() + " got interrupted"));
            }
        }
        log.info((Object)(this.getName() + " leaves cyberspace"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job acquireJob() {
        Job job = null;
        boolean debug = log.isDebugEnabled();
        JobExecutor jobExecutor = this.jobExecutor;
        synchronized (jobExecutor) {
            JbpmContext jbpmContext = this.jobExecutor.getJbpmConfiguration().createJbpmContext();
            try {
                Job firstJob = jbpmContext.getJobSession().getFirstAcquirableJob(null);
                if (firstJob != null) {
                    firstJob.setLockOwner(this.getName());
                    firstJob.setLockTime(new Date());
                    if (firstJob.getException() != null) {
                        int retries = firstJob.getRetries() - 1;
                        firstJob.setRetries(retries);
                        if (debug) {
                            log.debug((Object)(firstJob + " has " + retries + " retries remaining"));
                        }
                    }
                    if (debug) {
                        log.debug((Object)("acquired " + firstJob));
                    }
                    job = firstJob;
                } else if (debug) {
                    log.debug((Object)"no acquirable job found");
                }
            }
            catch (RuntimeException e) {
                jbpmContext.setRollbackOnly();
                if (debug) {
                    log.debug((Object)"failed to acquire job", (Throwable)e);
                }
            }
            catch (Error e) {
                jbpmContext.setRollbackOnly();
                throw e;
            }
            finally {
                block24: {
                    try {
                        jbpmContext.close();
                    }
                    catch (RuntimeException e) {
                        job = null;
                        if (!debug) break block24;
                        log.debug((Object)"failed to acquire job", (Throwable)e);
                    }
                }
            }
        }
        return job;
    }

    private void submitJob(Job job) {
        block2: {
            try {
                this.jobExecutor.getQueue().put((Object)job);
            }
            catch (InterruptedException e) {
                this.unlockJob(job);
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)(this.getName() + " got interrupted"));
            }
        }
    }

    private void unlockJob(Job job) {
        JbpmContext jbpmContext = this.jobExecutor.getJbpmConfiguration().createJbpmContext();
        try {
            jbpmContext.getJobSession().reattachJob(job);
            job.setLockOwner(null);
            job.setLockTime(null);
        }
        catch (RuntimeException e) {
            jbpmContext.setRollbackOnly();
            log.warn((Object)("failed to unlock " + job), (Throwable)e);
        }
        catch (Error e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        finally {
            try {
                jbpmContext.close();
            }
            catch (RuntimeException e) {
                log.warn((Object)("failed to unlock " + job), (Throwable)e);
            }
        }
    }

    private long getWaitPeriod(int currentIdleInterval) {
        long waitPeriod;
        Date nextDueDate = this.getNextDueDate();
        if (nextDueDate != null && (waitPeriod = nextDueDate.getTime() - System.currentTimeMillis()) < (long)currentIdleInterval) {
            return waitPeriod;
        }
        return currentIdleInterval;
    }

    private Date getNextDueDate() {
        Date nextDueDate = null;
        JbpmContext jbpmContext = this.jobExecutor.getJbpmConfiguration().createJbpmContext();
        try {
            Job job = jbpmContext.getJobSession().getFirstDueJob(null, null);
            if (job != null) {
                nextDueDate = job.getDueDate();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"no due job found");
            }
        }
        catch (RuntimeException e) {
            jbpmContext.setRollbackOnly();
            if (log.isDebugEnabled()) {
                log.debug((Object)"failed to determine next due date", (Throwable)e);
            }
        }
        catch (Error e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        finally {
            block18: {
                try {
                    jbpmContext.close();
                }
                catch (RuntimeException e) {
                    nextDueDate = null;
                    if (!log.isDebugEnabled()) break block18;
                    log.debug((Object)"failed to determine next due date", (Throwable)e);
                }
            }
        }
        return nextDueDate;
    }

    public void deactivate() {
        if (this.active) {
            this.active = false;
            this.interrupt();
        }
    }
}

