/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job.executor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.db.JobSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.job.Job;
import org.jbpm.job.executor.Deactivable;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.db.StaleObjectLogConfigurer;

public class JobExecutorThread
extends Thread
implements Deactivable {
    private final JobExecutor jobExecutor;
    private volatile boolean active = true;
    private static final Log log = LogFactory.getLog((Class)JobExecutorThread.class);

    public JobExecutorThread(String name, JobExecutor jobExecutor) {
        super(jobExecutor.getThreadGroup(), name);
        this.jobExecutor = jobExecutor;
    }

    public JobExecutorThread(String name, JobExecutor jobExecutor, JbpmConfiguration jbpmConfiguration, int idleInterval, int maxIdleInterval, long maxLockTime, int maxHistory) {
        super(jobExecutor.getThreadGroup(), name);
        this.jobExecutor = jobExecutor;
    }

    public void run() {
        while (this.active) {
            Job job = this.acquireJob();
            if (job == null) continue;
            try {
                this.executeJob(job);
            }
            catch (Exception e) {
                this.saveJobException(job, e);
            }
            catch (Error e) {
                this.unlockJob(job);
                throw e;
            }
        }
        log.info((Object)(this.getName() + " leaves cyberspace"));
    }

    protected Collection acquireJobs() {
        List jobs = Collections.EMPTY_LIST;
        boolean debug = log.isDebugEnabled();
        JbpmContext jbpmContext = this.jobExecutor.getJbpmConfiguration().createJbpmContext();
        try {
            String lockOwner = this.getName();
            JobSession jobSession = jbpmContext.getJobSession();
            Job firstJob = jobSession.getFirstAcquirableJob(lockOwner);
            if (firstJob != null) {
                if (firstJob.isExclusive()) {
                    ProcessInstance processInstance = firstJob.getProcessInstance();
                    List exclusiveJobs = jobSession.findExclusiveJobs(lockOwner, processInstance);
                    if (debug) {
                        log.debug((Object)("acquiring " + exclusiveJobs + " for " + processInstance));
                    }
                    Date lockTime = new Date();
                    Iterator i = exclusiveJobs.iterator();
                    while (i.hasNext()) {
                        Job exclusiveJob = (Job)i.next();
                        exclusiveJob.setLockOwner(lockOwner);
                        exclusiveJob.setLockTime(lockTime);
                    }
                    if (debug) {
                        log.debug((Object)("acquired " + exclusiveJobs));
                    }
                    jobs = exclusiveJobs;
                } else {
                    if (debug) {
                        log.debug((Object)("acquiring " + firstJob));
                    }
                    firstJob.setLockOwner(lockOwner);
                    firstJob.setLockTime(new Date());
                    if (debug) {
                        log.debug((Object)("acquired " + firstJob));
                    }
                    jobs = Collections.singletonList(firstJob);
                }
            } else if (debug) {
                log.debug((Object)"no acquirable job found");
            }
        }
        catch (RuntimeException e) {
            jbpmContext.setRollbackOnly();
            if (debug) {
                log.debug((Object)"failed to acquire jobs", (Throwable)e);
            }
        }
        catch (Error e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        finally {
            block25: {
                try {
                    jbpmContext.close();
                }
                catch (RuntimeException e) {
                    jobs = Collections.EMPTY_LIST;
                    if (!debug) break block25;
                    log.debug((Object)"failed to acquire jobs", (Throwable)e);
                }
            }
        }
        return jobs;
    }

    private Job acquireJob() {
        try {
            return (Job)this.jobExecutor.getQueue().take();
        }
        catch (InterruptedException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.getName() + " got interrupted"));
            }
            return null;
        }
    }

    protected void executeJob(Job job) throws Exception {
        JbpmContext jbpmContext = this.jobExecutor.getJbpmConfiguration().createJbpmContext();
        try {
            JobSession jobSession = jbpmContext.getJobSession();
            jobSession.reattachJob(job);
            ProcessInstance processInstance = job.getProcessInstance();
            jbpmContext.addAutoSaveProcessInstance(processInstance);
            if (job.isExclusive()) {
                jbpmContext.getGraphSession().lockProcessInstance(processInstance);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("executing " + job));
            }
            if (job.execute(jbpmContext)) {
                jobSession.deleteJob(job);
            }
        }
        catch (Exception e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        catch (Error e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        finally {
            jbpmContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveJobException(Job job, Exception exception) {
        if (DbPersistenceService.isLockingException(exception)) {
            StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)("failed to execute " + job), (Throwable)exception);
        } else {
            log.error((Object)("failed to execute " + job), (Throwable)exception);
        }
        JbpmContext jbpmContext = this.jobExecutor.getJbpmConfiguration().createJbpmContext();
        try {
            jbpmContext.getSession().refresh((Object)job);
            StringWriter out = new StringWriter();
            exception.printStackTrace(new PrintWriter(out));
            job.setException(out.toString());
            job.setLockOwner(null);
            job.setLockTime(null);
            JobExecutor jobExecutor = this.jobExecutor;
            synchronized (jobExecutor) {
                this.jobExecutor.notify();
            }
        }
        catch (RuntimeException e) {
            jbpmContext.setRollbackOnly();
            log.warn((Object)("failed to save exception for " + job), (Throwable)e);
        }
        catch (Error e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        finally {
            try {
                jbpmContext.close();
            }
            catch (RuntimeException e) {
                log.warn((Object)("failed to save exception for " + job), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockJob(Job job) {
        JbpmContext jbpmContext = this.jobExecutor.getJbpmConfiguration().createJbpmContext();
        try {
            jbpmContext.getSession().refresh((Object)job);
            job.setLockOwner(null);
            job.setLockTime(null);
            JobExecutor jobExecutor = this.jobExecutor;
            synchronized (jobExecutor) {
                this.jobExecutor.notify();
            }
        }
        catch (RuntimeException e) {
            jbpmContext.setRollbackOnly();
            log.warn((Object)("failed to unlock " + job), (Throwable)e);
        }
        catch (Error e) {
            jbpmContext.setRollbackOnly();
            log.warn((Object)("failed to unlock " + job), (Throwable)e);
        }
        finally {
            try {
                jbpmContext.close();
            }
            catch (RuntimeException e) {
                log.warn((Object)("failed to unlock " + job), (Throwable)e);
            }
        }
    }

    protected long getWaitPeriod(int currentIdleInterval) {
        long waitPeriod;
        Date nextDueDate = this.getNextDueDate();
        if (nextDueDate != null && (waitPeriod = nextDueDate.getTime() - System.currentTimeMillis()) < (long)currentIdleInterval) {
            return waitPeriod;
        }
        return currentIdleInterval;
    }

    protected Date getNextDueDate() {
        Date nextDueDate = null;
        JbpmContext jbpmContext = this.jobExecutor.getJbpmConfiguration().createJbpmContext();
        try {
            String lockOwner = this.getName();
            Job job = jbpmContext.getJobSession().getFirstDueJob(lockOwner, this.jobExecutor.getMonitoredJobIds());
            if (job != null) {
                this.jobExecutor.addMonitoredJobId(lockOwner, job.getId());
                nextDueDate = job.getDueDate();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"no due job found");
            }
        }
        catch (RuntimeException e) {
            jbpmContext.setRollbackOnly();
            if (log.isDebugEnabled()) {
                log.debug((Object)"failed to determine next due date", (Throwable)e);
            }
        }
        catch (Error e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        finally {
            block18: {
                try {
                    jbpmContext.close();
                }
                catch (RuntimeException e) {
                    nextDueDate = null;
                    if (!log.isDebugEnabled()) break block18;
                    log.debug((Object)"failed to determine next due date", (Throwable)e);
                }
            }
        }
        return nextDueDate;
    }

    public void setActive(boolean isActive) {
        if (!isActive) {
            this.deactivate();
        }
    }

    public void deactivate() {
        if (this.active) {
            this.active = false;
            this.interrupt();
        }
    }
}

