/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.exe;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class MilestoneInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected long id;
    protected String name;
    protected boolean reached;
    protected Token token;
    protected Collection listeners;

    public MilestoneInstance() {
    }

    public MilestoneInstance(String name) {
        this.name = name;
    }

    public static MilestoneInstance getMilestoneInstance(String milestoneName, Token token) {
        ContextInstance ci = token.getProcessInstance().getContextInstance();
        MilestoneInstance mi = (MilestoneInstance)ci.getVariable(milestoneName, token);
        if (mi == null) {
            mi = new MilestoneInstance(milestoneName);
            mi.setToken(token);
            ci.setVariable(milestoneName, mi);
        }
        return mi;
    }

    public void addListener(Token token) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(token);
    }

    public void notifyListeners() {
        if (this.listeners != null) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                Token token = (Token)iter.next();
                Node node = token.getNode();
                ExecutionContext executionContext = new ExecutionContext(token);
                node.leave(executionContext);
            }
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
    }

    public Collection getListeners() {
        return this.listeners;
    }

    public void setListeners(Collection listeners) {
        this.listeners = listeners;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isReached() {
        return this.reached;
    }

    public void setReached(boolean reached) {
        this.reached = reached;
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }
}

