/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.par;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.jpdl.JpdlException;
import org.jbpm.jpdl.par.ConfigurableParser;
import org.jbpm.jpdl.par.ProcessArchiveParser;
import org.jbpm.jpdl.xml.Problem;
import org.jbpm.jpdl.xml.ProblemListener;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.IoUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class ProcessArchive
implements ProblemListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map parsersByResource = new HashMap();
    private String name = "";
    private Map entries = new HashMap();
    private List problems = new ArrayList();

    public ProcessArchive(ZipInputStream zipInputStream) throws IOException {
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String entryName = zipEntry.getName();
            byte[] bytes = IoUtil.readBytes(zipInputStream);
            this.entries.put(entryName, bytes);
            zipEntry = zipInputStream.getNextEntry();
        }
    }

    public ProcessDefinition parseProcessDefinition() {
        ProcessDefinition processDefinition = ProcessDefinition.createNewProcessDefinition();
        Iterator iter = ProcessArchive.getParsers().iterator();
        while (iter.hasNext()) {
            ProcessArchiveParser processArchiveParser = (ProcessArchiveParser)iter.next();
            processDefinition = processArchiveParser.readFromArchive(this, processDefinition);
        }
        if (Problem.containsProblemsOfLevel(this.problems, 2)) {
            throw new JpdlException(this.problems);
        }
        return processDefinition;
    }

    public String toString() {
        return "process-archive(" + this.name + ")";
    }

    public Map getEntries() {
        return this.entries;
    }

    public byte[] getEntry(String entryName) {
        return (byte[])this.entries.get(entryName);
    }

    public InputStream getEntryInputStream(String entryName) {
        return new ByteArrayInputStream(this.getEntry(entryName));
    }

    public byte[] removeEntry(String entryName) {
        return (byte[])this.entries.remove(entryName);
    }

    public InputStream removeEntryInputStream(String entryName) {
        return new ByteArrayInputStream(this.removeEntry(entryName));
    }

    public void addProblem(Problem problem) {
        this.problems.add(problem);
    }

    public List getProblems() {
        return this.problems;
    }

    public void resetProblems() {
        this.problems = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getParsers() {
        String resource = JbpmConfiguration.Configs.getString("resource.parsers");
        Map map = parsersByResource;
        synchronized (map) {
            List parsers = (List)parsersByResource.get(resource);
            if (parsers == null) {
                parsers = ProcessArchive.createParsers(resource);
                parsersByResource.put(resource, parsers);
            }
            return parsers;
        }
    }

    private static List createParsers(String resource) {
        InputStream resourceStream = ClassLoaderUtil.getStream(resource);
        Element parsersElement = XmlUtil.parseXmlInputStream(resourceStream).getDocumentElement();
        ArrayList<ProcessArchiveParser> parsers = new ArrayList<ProcessArchiveParser>();
        Log log = LogFactory.getLog((Class)ProcessArchive.class);
        boolean debug = log.isDebugEnabled();
        Iterator iter = XmlUtil.elementIterator(parsersElement, "parser");
        while (iter.hasNext()) {
            Element parserElement = (Element)iter.next();
            String parserClassName = parserElement.getAttribute("class");
            try {
                Class parserClass = ClassLoaderUtil.classForName(parserClassName);
                try {
                    ProcessArchiveParser parser = (ProcessArchiveParser)parserClass.newInstance();
                    if (parser instanceof ConfigurableParser) {
                        ((ConfigurableParser)parser).configure(parserElement);
                    }
                    parsers.add(parser);
                    if (!debug) continue;
                    log.debug((Object)("loaded " + parserClass));
                }
                catch (InstantiationException e) {
                    if (!debug) continue;
                    log.debug((Object)("failed to instantiate " + parserClass), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    if (!debug) continue;
                    log.debug((Object)((class$org$jbpm$jpdl$par$ProcessArchive == null ? ProcessArchive.class$("org.jbpm.jpdl.par.ProcessArchive") : class$org$jbpm$jpdl$par$ProcessArchive) + " has no access to " + parserClass), (Throwable)e);
                }
            }
            catch (ClassNotFoundException e) {
                if (!debug) continue;
                log.debug((Object)("parser not found: " + parserClassName), (Throwable)e);
            }
        }
        return parsers;
    }
}

