/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.taskmgmt.exe;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.context.exe.VariableContainer;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Identifiable;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.Comment;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.security.SecurityHelper;
import org.jbpm.taskmgmt.def.Swimlane;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.def.TaskController;
import org.jbpm.taskmgmt.def.TaskMgmtDefinition;
import org.jbpm.taskmgmt.exe.Assignable;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.taskmgmt.exe.SwimlaneInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;
import org.jbpm.taskmgmt.log.TaskAssignLog;
import org.jbpm.taskmgmt.log.TaskEndLog;
import org.jbpm.util.Clock;

public class TaskInstance
extends VariableContainer
implements Identifiable,
Assignable {
    private static final long serialVersionUID = 1L;
    long id;
    int version;
    protected String name;
    protected String description;
    protected String actorId;
    protected Date create;
    protected Date start;
    protected Date end;
    protected Date dueDate;
    protected int priority = 3;
    protected boolean isCancelled;
    protected boolean isSuspended;
    protected boolean isOpen = true;
    protected boolean isSignalling = true;
    protected boolean isBlocking;
    protected Task task;
    protected Token token;
    protected SwimlaneInstance swimlaneInstance;
    protected TaskMgmtInstance taskMgmtInstance;
    protected ProcessInstance processInstance;
    protected Set pooledActors;
    protected List comments;
    protected String previousActorId;
    private static final Log log = LogFactory.getLog((Class)TaskInstance.class);

    public TaskInstance() {
    }

    public TaskInstance(String taskName) {
        this.name = taskName;
    }

    public TaskInstance(String taskName, String actorId) {
        this.name = taskName;
        this.actorId = actorId;
    }

    public void setTask(Task task) {
        this.name = task.getName();
        this.description = task.getDescription();
        this.task = task;
        this.isBlocking = task.isBlocking();
        this.priority = task.getPriority();
        this.isSignalling = task.isSignalling();
    }

    private void submitVariables() {
        TaskController taskController;
        if (this.task != null && (taskController = this.task.getTaskController()) != null) {
            taskController.submitParameters(this);
        } else if (this.token != null && this.variableInstances != null) {
            ContextInstance contextInstance = this.token.getProcessInstance().getContextInstance();
            boolean debug = log.isDebugEnabled();
            Iterator iter = this.variableInstances.values().iterator();
            while (iter.hasNext()) {
                VariableInstance variableInstance = (VariableInstance)iter.next();
                String variableName = variableInstance.getName();
                if (debug) {
                    log.debug((Object)(this + " writes '" + variableName + '\''));
                }
                contextInstance.setVariable(variableName, variableInstance.getValue(), this.token);
            }
        }
    }

    void initializeVariables() {
        TaskController taskController;
        if (this.task != null && (taskController = this.task.getTaskController()) != null) {
            taskController.initializeVariables(this);
        }
    }

    public void create() {
        this.create(null);
    }

    public void create(ExecutionContext executionContext) {
        if (this.create != null) {
            throw new IllegalStateException(this + " was already created");
        }
        this.create = Clock.getCurrentTime();
        if (this.task != null && executionContext != null) {
            executionContext.setTaskInstance(this);
            executionContext.setTask(this.task);
            this.task.fireEvent("task-create", executionContext);
        }
    }

    public void assign(ExecutionContext executionContext) {
        TaskMgmtInstance taskMgmtInstance = executionContext.getTaskMgmtInstance();
        Swimlane swimlane = this.task.getSwimlane();
        if (swimlane != null) {
            if (this.isStartTaskInstance()) {
                this.swimlaneInstance = new SwimlaneInstance(swimlane);
                taskMgmtInstance.addSwimlaneInstance(this.swimlaneInstance);
                this.swimlaneInstance.setActorId(SecurityHelper.getAuthenticatedActorId());
            } else {
                this.swimlaneInstance = taskMgmtInstance.getInitializedSwimlaneInstance(executionContext, swimlane);
                this.copySwimlaneInstanceAssignment(this.swimlaneInstance);
            }
        } else {
            taskMgmtInstance.performAssignment(this.task.getAssignmentDelegation(), this.task.getActorIdExpression(), this.task.getPooledActorsExpression(), this, executionContext);
        }
        this.updatePooledActorsReferences(this.swimlaneInstance);
    }

    public boolean isStartTaskInstance() {
        TaskMgmtDefinition taskMgmtDefinition;
        if (this.taskMgmtInstance != null && (taskMgmtDefinition = this.taskMgmtInstance.getTaskMgmtDefinition()) != null) {
            return this.task != null && this.task.equals(this.taskMgmtInstance.getTaskMgmtDefinition().getStartTask());
        }
        return false;
    }

    private void updatePooledActorsReferences(SwimlaneInstance swimlaneInstance) {
        if (this.pooledActors != null) {
            Iterator iter = this.pooledActors.iterator();
            while (iter.hasNext()) {
                PooledActor pooledActor = (PooledActor)iter.next();
                pooledActor.setSwimlaneInstance(swimlaneInstance);
                pooledActor.addTaskInstance(this);
            }
        }
    }

    public void copySwimlaneInstanceAssignment(SwimlaneInstance swimlaneInstance) {
        this.setSwimlaneInstance(swimlaneInstance);
        this.setActorId(swimlaneInstance.getActorId());
        this.setPooledActors(swimlaneInstance.getPooledActors());
    }

    public Set getPooledActors() {
        if (this.swimlaneInstance != null && (this.pooledActors == null || this.pooledActors.isEmpty())) {
            return this.swimlaneInstance.getPooledActors();
        }
        return this.pooledActors;
    }

    public void setActorId(String actorId) {
        this.setActorId(actorId, true);
    }

    public void setActorId(String actorId, boolean overwriteSwimlane) {
        this.previousActorId = this.actorId;
        this.actorId = actorId;
        if (this.swimlaneInstance != null && overwriteSwimlane) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("assigning " + this + " to '" + actorId + '\''));
            }
            this.swimlaneInstance.setActorId(actorId);
        }
        if (this.token != null) {
            this.token.addLog(new TaskAssignLog(this, this.previousActorId, actorId));
            if (this.task != null) {
                ExecutionContext executionContext = new ExecutionContext(this.token);
                executionContext.setTask(this.task);
                executionContext.setTaskInstance(this);
                this.task.fireEvent("task-assign", executionContext);
            }
        }
    }

    public void setPooledActors(String[] actorIds) {
        this.pooledActors = PooledActor.createPool(actorIds, null, this);
    }

    public void start() {
        if (this.start != null) {
            throw new IllegalStateException(this + " is already started");
        }
        this.start = Clock.getCurrentTime();
        if (this.token != null && this.task != null) {
            ExecutionContext executionContext = new ExecutionContext(this.token);
            executionContext.setTask(this.task);
            executionContext.setTaskInstance(this);
            this.task.fireEvent("task-start", executionContext);
        }
    }

    public void start(String actorId) {
        this.start(actorId, true);
    }

    public void start(String actorId, boolean overwriteSwimlane) {
        this.setActorId(actorId, overwriteSwimlane);
        this.start();
    }

    public void setStart(Date date) {
        this.start = null;
    }

    private void markAsCancelled() {
        this.isCancelled = true;
        this.isOpen = false;
    }

    public void cancel() {
        this.markAsCancelled();
        this.end();
    }

    public void cancel(Transition transition) {
        this.markAsCancelled();
        this.end(transition);
    }

    public void cancel(String transitionName) {
        this.markAsCancelled();
        this.end(transitionName);
    }

    public void end() {
        this.end((Transition)null);
    }

    public void end(String transitionName) {
        Transition leavingTransition;
        if (this.task == null) {
            throw new JbpmException(this + " has no task definition");
        }
        Node node = this.task.getTaskNode();
        if (node == null) {
            GraphElement parent = this.task.getParent();
            if (!(parent instanceof Node)) {
                throw new JbpmException(this + " has no enclosing node");
            }
            node = (Node)parent;
        }
        if ((leavingTransition = node.getLeavingTransition(transitionName)) == null) {
            throw new JbpmException(node + " has no leaving transition named " + transitionName);
        }
        this.end(leavingTransition);
    }

    public void end(Transition transition) {
        if (this.end != null) {
            throw new IllegalStateException(this + " has ended");
        }
        if (this.isSuspended) {
            throw new JbpmException(this + " is suspended");
        }
        this.end = Clock.getCurrentTime();
        this.isOpen = false;
        if (this.token != null) {
            this.submitVariables();
            this.token.addLog(new TaskEndLog(this));
            if (this.task != null) {
                ExecutionContext executionContext = new ExecutionContext(this.token);
                executionContext.setTask(this.task);
                executionContext.setTaskInstance(this);
                this.task.fireEvent("task-end", executionContext);
                if (this.isSignalling) {
                    this.isSignalling = false;
                    TaskNode taskNode = this.task.getTaskNode();
                    if (this.isStartTaskInstance() || taskNode != null && taskNode.completionTriggersSignal(this)) {
                        boolean debug = log.isDebugEnabled();
                        if (transition == null) {
                            if (debug) {
                                log.debug((Object)("taking default transition after completing " + this.task));
                            }
                            this.token.signal();
                        } else {
                            if (debug) {
                                log.debug((Object)("taking" + transition + " after completing " + this.task));
                            }
                            this.token.signal(transition);
                        }
                    }
                }
            }
        }
    }

    public boolean hasEnded() {
        return this.end != null;
    }

    public void suspend() {
        if (!this.isOpen) {
            throw new JbpmException("task is not open");
        }
        this.isSuspended = true;
    }

    public void resume() {
        if (!this.isOpen) {
            throw new JbpmException("task is not open");
        }
        this.isSuspended = false;
    }

    public void addComment(String message) {
        this.addComment(new Comment(message));
    }

    public void addComment(Comment comment) {
        if (comment != null) {
            if (this.comments == null) {
                this.comments = new ArrayList();
            }
            this.comments.add(comment);
            comment.setTaskInstance(this);
            if (this.token != null) {
                comment.setToken(this.token);
                this.token.addComment(comment);
            }
        }
    }

    public List getComments() {
        return this.comments;
    }

    public boolean isLast() {
        return this.token != null && this.taskMgmtInstance != null && !this.taskMgmtInstance.hasUnfinishedTasks(this.token);
    }

    public List getAvailableTransitions() {
        ArrayList transitions = null;
        if (!this.isLast() && this.token != null) {
            transitions = new ArrayList(this.token.getAvailableTransitions());
        }
        return transitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskInstance)) {
            return false;
        }
        TaskInstance other = (TaskInstance)o;
        return this.id != 0L && this.id == other.getId();
    }

    public String toString() {
        return "TaskInstance" + (this.name != null ? '(' + this.name + ')' : (this.id != 0L ? "(" + this.id + ')' : '@' + Integer.toHexString(this.hashCode())));
    }

    public void setPooledActors(Set pooledActors) {
        if (pooledActors != null) {
            this.pooledActors = new HashSet(pooledActors);
            Iterator iter = pooledActors.iterator();
            while (iter.hasNext()) {
                PooledActor pooledActor = (PooledActor)iter.next();
                pooledActor.addTaskInstance(this);
            }
        } else {
            this.pooledActors = null;
        }
    }

    protected VariableContainer getParentVariableContainer() {
        ContextInstance contextInstance = this.getContextInstance();
        return contextInstance != null ? contextInstance.getOrCreateTokenVariableMap(this.token) : null;
    }

    public String getActorId() {
        return this.actorId;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public void setCreate(Date create) {
        this.create = create;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
    }

    public Date getStart() {
        return this.start;
    }

    public TaskMgmtInstance getTaskMgmtInstance() {
        return this.taskMgmtInstance;
    }

    public void setTaskMgmtInstance(TaskMgmtInstance taskMgmtInstance) {
        this.taskMgmtInstance = taskMgmtInstance;
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public void setSignalling(boolean isSignalling) {
        this.isSignalling = isSignalling;
    }

    public boolean isSignalling() {
        return this.isSignalling;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isBlocking() {
        return this.isBlocking;
    }

    public void setBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
    }

    public Date getCreate() {
        return this.create;
    }

    public Task getTask() {
        return this.task;
    }

    public SwimlaneInstance getSwimlaneInstance() {
        return this.swimlaneInstance;
    }

    public void setSwimlaneInstance(SwimlaneInstance swimlaneInstance) {
        this.swimlaneInstance = swimlaneInstance;
    }

    public String getPreviousActorId() {
        return this.previousActorId;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }
}

