/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Node;

class NodeIterator
implements Iterator {
    private Node currentNode;
    private Node lastReturned;

    public NodeIterator(Node parentNode) {
        this.currentNode = parentNode.getFirstChild();
    }

    public boolean hasNext() {
        return this.currentNode != null;
    }

    public Object next() {
        if (this.currentNode == null) {
            throw new NoSuchElementException();
        }
        this.lastReturned = this.currentNode;
        this.currentNode = this.lastReturned.getNextSibling();
        return this.lastReturned;
    }

    public void remove() {
        if (this.lastReturned == null) {
            throw new IllegalStateException();
        }
        Node parentNode = this.lastReturned.getParentNode();
        if (parentNode != null) {
            parentNode.removeChild(this.lastReturned);
        }
        this.lastReturned = null;
    }
}

