/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.exe;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.db.JobSession;
import org.jbpm.graph.def.Identifiable;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.Comment;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.log.SignalLog;
import org.jbpm.graph.log.TokenCreateLog;
import org.jbpm.graph.log.TokenEndLog;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.logging.exe.LoggingInstance;
import org.jbpm.logging.log.CompositeLog;
import org.jbpm.logging.log.ProcessLog;
import org.jbpm.svc.Services;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;
import org.jbpm.util.Clock;

public class Token
implements Identifiable,
Serializable {
    private static final long serialVersionUID = 1L;
    long id;
    int version;
    protected String name;
    protected Date start;
    protected Date end;
    protected Node node;
    protected Date nodeEnter;
    protected ProcessInstance processInstance;
    protected Token parent;
    protected Map children;
    protected List comments;
    protected ProcessInstance subProcessInstance;
    protected int nextLogIndex;
    private boolean isAbleToReactivateParent = true;
    private boolean isTerminationImplicit;
    private boolean isSuspended;
    private String lock;
    private static final Log log = LogFactory.getLog((Class)Token.class);
    static /* synthetic */ Class class$java$lang$Boolean;

    public Token() {
    }

    public Token(ProcessInstance processInstance) {
        this.start = Clock.getCurrentTime();
        this.processInstance = processInstance;
        this.node = processInstance.getProcessDefinition().getStartState();
        this.isTerminationImplicit = processInstance.getProcessDefinition().isTerminationImplicit();
    }

    public Token(Token parent, String name) {
        this.start = Clock.getCurrentTime();
        this.processInstance = parent.getProcessInstance();
        this.name = name;
        this.node = parent.getNode();
        this.parent = parent;
        parent.addChild(this);
        this.isTerminationImplicit = parent.isTerminationImplicit();
        parent.addLog(new TokenCreateLog(this));
        Services.assignId(this);
    }

    private void addChild(Token token) {
        if (this.children == null) {
            this.children = new HashMap();
        }
        this.children.put(token.getName(), token);
    }

    public void signal() {
        if (this.node == null) {
            throw new JbpmException(this + " is not positioned in a node");
        }
        Transition defaultTransition = this.node.getDefaultLeavingTransition();
        if (defaultTransition == null) {
            throw new JbpmException(this.node + " has no default transition");
        }
        this.signal(defaultTransition, new ExecutionContext(this));
    }

    public void signal(String transitionName) {
        if (this.node == null) {
            throw new JbpmException(this + " is not positioned in a node");
        }
        Transition leavingTransition = this.node.getLeavingTransition(transitionName);
        if (leavingTransition == null) {
            Iterator iter = this.node.getLeavingTransitions().iterator();
            while (iter.hasNext()) {
                Transition transition = (Transition)iter.next();
                if (!transitionName.equals(transition.getTo().getName())) continue;
                leavingTransition = transition;
                break;
            }
            if (leavingTransition == null) {
                throw new JbpmException(this.node + " has no leaving transition named " + transitionName);
            }
        }
        this.signal(leavingTransition, new ExecutionContext(this));
    }

    public void signal(Transition transition) {
        this.signal(transition, new ExecutionContext(this));
    }

    void signal(ExecutionContext executionContext) {
        this.signal(this.node.getDefaultLeavingTransition(), executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signal(Transition transition, ExecutionContext executionContext) {
        if (transition == null) {
            throw new JbpmException("transition is null");
        }
        if (executionContext == null) {
            throw new JbpmException("execution context is null");
        }
        if (this.isSuspended) {
            throw new JbpmException("token is suspended");
        }
        if (this.isLocked()) {
            throw new JbpmException("token is locked by " + this.lock);
        }
        if (this.hasEnded()) {
            throw new JbpmException("token has ended");
        }
        this.startCompositeLog(new SignalLog(transition));
        try {
            Node signalNode = this.node;
            signalNode.fireEvent("before-signal", executionContext);
            this.node.leave(executionContext, transition);
            this.checkImplicitTermination();
            signalNode.fireEvent("after-signal", executionContext);
        }
        finally {
            this.endCompositeLog();
        }
    }

    public Set getAvailableTransitions() {
        if (this.node == null) {
            return Collections.EMPTY_SET;
        }
        HashSet availableTransitions = new HashSet();
        this.addAvailableTransitionsOfNode(this.node, availableTransitions);
        return availableTransitions;
    }

    private void addAvailableTransitionsOfNode(Node currentNode, Set availableTransitions) {
        List leavingTransitions = currentNode.getLeavingTransitions();
        if (leavingTransitions != null) {
            Iterator iter = leavingTransitions.iterator();
            while (iter.hasNext()) {
                Transition transition = (Transition)iter.next();
                String conditionExpression = transition.getCondition();
                if (conditionExpression != null) {
                    Boolean result = (Boolean)JbpmExpressionEvaluator.evaluate(conditionExpression, new ExecutionContext(this), class$java$lang$Boolean == null ? Token.class$("java.lang.Boolean") : class$java$lang$Boolean);
                    if (!Boolean.TRUE.equals(result)) continue;
                    availableTransitions.add(transition);
                    continue;
                }
                availableTransitions.add(transition);
            }
        }
        if (currentNode.getSuperState() != null) {
            this.addAvailableTransitionsOfNode(currentNode.getSuperState(), availableTransitions);
        }
    }

    public void end() {
        this.end(true);
    }

    public void end(boolean verifyParentTermination) {
        TaskMgmtInstance taskMgmtInstance;
        if (this.end != null) {
            if (this.parent != null) {
                log.warn((Object)(this + " has ended already"));
            }
            return;
        }
        this.end = Clock.getCurrentTime();
        this.isAbleToReactivateParent = false;
        if (this.children != null) {
            Iterator iter = this.children.values().iterator();
            while (iter.hasNext()) {
                Token child = (Token)iter.next();
                if (child.hasEnded()) continue;
                child.end();
            }
        }
        if (this.subProcessInstance != null) {
            this.subProcessInstance.end();
        }
        if (this.parent != null) {
            this.parent.addLog(new TokenEndLog(this));
        }
        if ((taskMgmtInstance = this.processInstance.getTaskMgmtInstance()) != null) {
            taskMgmtInstance.removeSignalling(this);
        }
        if (verifyParentTermination) {
            this.notifyParentOfTokenEnd();
        }
    }

    public void addComment(String message) {
        this.addComment(new Comment(message));
    }

    public void addComment(Comment comment) {
        if (this.comments == null) {
            this.comments = new ArrayList();
        }
        this.comments.add(comment);
        comment.setToken(this);
    }

    public List getComments() {
        return this.comments;
    }

    private void notifyParentOfTokenEnd() {
        if (this.isRoot()) {
            this.processInstance.end();
        } else if (this.parent != null && !this.parent.hasActiveChildren()) {
            this.parent.end();
        }
    }

    public boolean hasActiveChildren() {
        if (this.children != null) {
            Iterator iter = this.children.values().iterator();
            while (iter.hasNext()) {
                Token child = (Token)iter.next();
                if (child.hasEnded()) continue;
                return true;
            }
        }
        return false;
    }

    public void addLog(ProcessLog processLog) {
        LoggingInstance loggingInstance = this.processInstance.getLoggingInstance();
        if (loggingInstance != null) {
            processLog.setToken(this);
            loggingInstance.addLog(processLog);
        }
    }

    public void startCompositeLog(CompositeLog compositeLog) {
        LoggingInstance loggingInstance = this.processInstance.getLoggingInstance();
        if (loggingInstance != null) {
            compositeLog.setToken(this);
            loggingInstance.startCompositeLog(compositeLog);
        }
    }

    public void endCompositeLog() {
        LoggingInstance loggingInstance = this.processInstance.getLoggingInstance();
        if (loggingInstance != null) {
            loggingInstance.endCompositeLog();
        }
    }

    public boolean hasEnded() {
        return this.end != null;
    }

    public boolean isRoot() {
        return this.processInstance != null && this.equals(this.processInstance.getRootToken());
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean hasChild(String name) {
        return this.children != null ? this.children.containsKey(name) : false;
    }

    public Token getChild(String name) {
        return this.children != null ? (Token)this.children.get(name) : null;
    }

    public String getFullName() {
        if (this.isRoot()) {
            return "/";
        }
        StringBuffer nameBuilder = new StringBuffer();
        Token token = this;
        while (token.hasParent()) {
            String tokenName = token.getName();
            if (tokenName != null) {
                nameBuilder.insert(0, tokenName);
            }
            nameBuilder.insert(0, '/');
            token = token.getParent();
        }
        return nameBuilder.toString();
    }

    public List getChildrenAtNode(Node aNode) {
        ArrayList foundChildren = new ArrayList();
        this.getChildrenAtNode(aNode, foundChildren);
        return foundChildren;
    }

    private void getChildrenAtNode(Node aNode, List foundTokens) {
        if (aNode.equals(this.node)) {
            foundTokens.add(this);
        } else if (this.children != null) {
            Iterator it = this.children.values().iterator();
            while (it.hasNext()) {
                Token child = (Token)it.next();
                child.getChildrenAtNode(aNode, foundTokens);
            }
        }
    }

    public void collectChildrenRecursively(List tokens) {
        if (this.children != null) {
            Iterator iter = this.children.values().iterator();
            while (iter.hasNext()) {
                Token child = (Token)iter.next();
                tokens.add(child);
                child.collectChildrenRecursively(tokens);
            }
        }
    }

    public Token findToken(String relativeTokenPath) {
        if (relativeTokenPath == null) {
            return null;
        }
        String path = relativeTokenPath.trim();
        if (path.length() == 0 || ".".equals(path)) {
            return this;
        }
        if ("..".equals(path)) {
            return this.parent;
        }
        if (path.startsWith("/")) {
            return this.processInstance.getRootToken().findToken(path.substring(1));
        }
        if (path.startsWith("./")) {
            return this.findToken(path.substring(2));
        }
        if (path.startsWith("../")) {
            return this.parent != null ? this.parent.findToken(path.substring(3)) : null;
        }
        if (this.children == null) {
            return null;
        }
        int slashIndex = path.indexOf(47);
        if (slashIndex == -1) {
            return (Token)this.children.get(path);
        }
        Token token = (Token)this.children.get(path.substring(0, slashIndex));
        return token != null ? token.findToken(path.substring(slashIndex + 1)) : null;
    }

    public Map getActiveChildren() {
        HashMap<String, Token> activeChildren = new HashMap<String, Token>();
        if (this.children != null) {
            Iterator iter = this.children.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Token child = (Token)entry.getValue();
                if (child.hasEnded()) continue;
                String childName = (String)entry.getKey();
                activeChildren.put(childName, child);
            }
        }
        return activeChildren;
    }

    public void checkImplicitTermination() {
        if (this.isTerminationImplicit && this.node.hasNoLeavingTransitions()) {
            this.end();
            if (this.processInstance.isTerminatedImplicitly()) {
                this.processInstance.end();
            }
        }
    }

    public boolean isTerminatedImplicitly() {
        if (this.end != null) {
            return true;
        }
        Map leavingTransitions = this.node.getLeavingTransitionsMap();
        if (leavingTransitions != null && !leavingTransitions.isEmpty()) {
            return false;
        }
        Iterator iter = this.getActiveChildren().values().iterator();
        while (iter.hasNext()) {
            Token child = (Token)iter.next();
            if (child.isTerminatedImplicitly()) continue;
            return false;
        }
        return true;
    }

    public int nextLogIndex() {
        return this.nextLogIndex++;
    }

    public void suspend() {
        this.isSuspended = true;
        this.suspendJobs();
        this.suspendTaskInstances();
        if (this.children != null) {
            Iterator iter = this.children.values().iterator();
            while (iter.hasNext()) {
                Token child = (Token)iter.next();
                child.suspend();
            }
        }
    }

    private void suspendJobs() {
        JobSession jobSession;
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext != null && (jobSession = jbpmContext.getJobSession()) != null) {
            jobSession.suspendJobs(this);
        }
    }

    private void suspendTaskInstances() {
        TaskMgmtInstance taskMgmtInstance = this.processInstance.getTaskMgmtInstance();
        if (taskMgmtInstance != null) {
            taskMgmtInstance.suspend(this);
        }
    }

    public void resume() {
        this.isSuspended = false;
        this.resumeJobs();
        this.resumeTaskInstances();
        if (this.children != null) {
            Iterator iter = this.children.values().iterator();
            while (iter.hasNext()) {
                Token child = (Token)iter.next();
                child.resume();
            }
        }
    }

    private void resumeJobs() {
        JobSession jobSession;
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext != null && (jobSession = jbpmContext.getJobSession()) != null) {
            jobSession.resumeJobs(this);
        }
    }

    private void resumeTaskInstances() {
        TaskMgmtInstance taskMgmtInstance = this.processInstance.getTaskMgmtInstance();
        if (taskMgmtInstance != null) {
            taskMgmtInstance.resume(this);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token other = (Token)o;
        if (this.id != 0L && this.id == other.getId()) {
            return true;
        }
        return (this.name != null ? this.name.equals(other.getName()) : other.getName() == null) && (this.parent != null ? this.parent.equals(other.getParent()) : this.processInstance.equals(other.getProcessInstance()));
    }

    public int hashCode() {
        int result = 2080763213 + (this.name != null ? this.name.hashCode() : 0);
        result = 1076685199 * result + (this.parent != null ? this.parent.hashCode() : this.processInstance.hashCode());
        return result;
    }

    public String toString() {
        return "Token(" + (this.id != 0L ? String.valueOf(this.id) : this.getFullName()) + ')';
    }

    public ProcessInstance createSubProcessInstance(ProcessDefinition subProcessDefinition) {
        this.subProcessInstance = new ProcessInstance(subProcessDefinition);
        this.setSubProcessInstance(this.subProcessInstance);
        this.subProcessInstance.setSuperProcessToken(this);
        this.processInstance.addCascadeProcessInstance(this.subProcessInstance);
        return this.subProcessInstance;
    }

    public void lock(String lockOwner) {
        if (lockOwner == null) {
            throw new JbpmException("lock owner is null");
        }
        if (this.lock == null) {
            this.lock = lockOwner;
            if (log.isDebugEnabled()) {
                log.debug((Object)('\'' + lockOwner + "' locked " + this));
            }
        } else if (!this.lock.equals(lockOwner)) {
            throw new JbpmException('\'' + lockOwner + "' cannot lock " + this + " because '" + this.lock + "' already locked it");
        }
    }

    public void unlock(String lockOwner) {
        if (this.lock != null) {
            if (!this.lock.equals(lockOwner)) {
                throw new JbpmException('\'' + lockOwner + "' cannot unlock " + this + " because '" + this.lock + "' locked it");
            }
            this.lock = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)('\'' + lockOwner + "' unlocked " + this));
            }
        } else {
            log.warn((Object)(this + " was already unlocked"));
        }
    }

    public void foreUnlock() {
        this.forceUnlock();
    }

    public void forceUnlock() {
        if (this.lock != null) {
            this.lock = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("forcefully unlocked " + this));
            }
        } else {
            log.warn((Object)(this + " was unlocked already"));
        }
    }

    public String getLockOwner() {
        return this.lock;
    }

    public boolean isLocked() {
        return this.lock != null;
    }

    public long getId() {
        return this.id;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public String getName() {
        return this.name;
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public Map getChildren() {
        return this.children;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public Token getParent() {
        return this.parent;
    }

    public void setParent(Token parent) {
        this.parent = parent;
    }

    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    public ProcessInstance getSubProcessInstance() {
        return this.subProcessInstance;
    }

    public Date getNodeEnter() {
        return this.nodeEnter;
    }

    public void setNodeEnter(Date nodeEnter) {
        this.nodeEnter = nodeEnter;
    }

    public boolean isAbleToReactivateParent() {
        return this.isAbleToReactivateParent;
    }

    public void setAbleToReactivateParent(boolean isAbleToReactivateParent) {
        this.isAbleToReactivateParent = isAbleToReactivateParent;
    }

    public boolean isTerminationImplicit() {
        return this.isTerminationImplicit;
    }

    public void setTerminationImplicit(boolean isTerminationImplicit) {
        this.isTerminationImplicit = isTerminationImplicit;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void setSubProcessInstance(ProcessInstance subProcessInstance) {
        this.subProcessInstance = subProcessInstance;
    }
}

