/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.node.DecisionCondition;
import org.jbpm.graph.node.DecisionHandler;
import org.jbpm.instantiation.Delegation;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.jpdl.xml.JpdlXmlReader;

public class Decision
extends Node {
    private List decisionConditions;
    private Delegation decisionDelegation;
    private String decisionExpression;
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog((Class)Decision.class);
    static /* synthetic */ Class class$java$lang$Boolean;

    public Decision() {
    }

    public Decision(String name) {
        super(name);
    }

    public Node.NodeType getNodeType() {
        return Node.NodeType.Decision;
    }

    public void read(Element decisionElement, JpdlXmlReader jpdlReader) {
        String expression = decisionElement.attributeValue("expression");
        Element decisionHandlerElement = decisionElement.element("handler");
        if (expression != null) {
            this.decisionExpression = expression;
        } else if (decisionHandlerElement != null) {
            this.decisionDelegation = new Delegation();
            this.decisionDelegation.read(decisionHandlerElement, jpdlReader);
        }
    }

    public Transition addLeavingTransition(Transition leavingTransition) {
        leavingTransition.setConditionEnforced(false);
        return super.addLeavingTransition(leavingTransition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext executionContext) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader processClassLoader = JbpmConfiguration.getProcessClassLoader(executionContext.getProcessDefinition());
            Thread.currentThread().setContextClassLoader(processClassLoader);
            Transition transition = null;
            if (this.decisionDelegation != null) {
                transition = this.handleDecision(executionContext);
            } else if (this.decisionExpression != null) {
                String transitionName = (String)JbpmExpressionEvaluator.evaluate(this.decisionExpression, executionContext, String.class);
                transition = this.getLeavingTransition(transitionName);
                if (transition == null) {
                    throw new JbpmException("no such transition: " + transitionName);
                }
            } else if (this.decisionConditions != null && !this.decisionConditions.isEmpty()) {
                String transitionName;
                DecisionCondition decisionCondition;
                String expression;
                Boolean result;
                Iterator iter = this.decisionConditions.iterator();
                while (iter.hasNext() && (!Boolean.TRUE.equals(result = (Boolean)JbpmExpressionEvaluator.evaluate(expression = (decisionCondition = (DecisionCondition)iter.next()).getExpression(), executionContext, class$java$lang$Boolean == null ? Decision.class$("java.lang.Boolean") : class$java$lang$Boolean)) || (transition = this.getLeavingTransition(transitionName = decisionCondition.getTransitionName())) == null)) {
                }
            } else {
                Iterator iter = this.leavingTransitions.iterator();
                while (iter.hasNext()) {
                    Boolean result;
                    Transition candidate = (Transition)iter.next();
                    String condition = candidate.getCondition();
                    if (condition == null || !Boolean.TRUE.equals(result = (Boolean)JbpmExpressionEvaluator.evaluate(condition, executionContext, class$java$lang$Boolean == null ? Decision.class$("java.lang.Boolean") : class$java$lang$Boolean))) continue;
                    transition = candidate;
                    break;
                }
            }
            if (transition == null && (transition = this.getDefaultLeavingTransition()) == null) {
                throw new JbpmException(this + " has no default transition");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(executionContext.getToken() + " leaves " + this + " over " + transition));
            }
            executionContext.leaveNode(transition);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private Transition handleDecision(ExecutionContext executionContext) {
        String transitionName;
        DecisionHandler decisionHandler = (DecisionHandler)this.decisionDelegation.getInstance();
        try {
            transitionName = decisionHandler.decide(executionContext);
        }
        catch (Exception e) {
            this.raiseException(e, executionContext);
            return null;
        }
        Transition transition = this.getLeavingTransition(transitionName);
        if (transition == null) {
            throw new JbpmException("no such transition: " + transitionName);
        }
        return transition;
    }

    public List getDecisionConditions() {
        return this.decisionConditions;
    }

    public Delegation getDecisionDelegation() {
        return this.decisionDelegation;
    }

    public void setDecisionDelegation(Delegation decisionDelegation) {
        this.decisionDelegation = decisionDelegation;
    }
}

