/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.db;

import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ObjectFactory;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Timer;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.scheduler.SchedulerService;

public class DbSchedulerService
implements SchedulerService {
    private final JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
    private boolean hasProducedTimers;
    private static final String CALENDAR_RESOURCE = "resource.business.calendar";
    private static final long serialVersionUID = 1L;

    public DbSchedulerService() {
        if (this.jbpmContext == null) {
            throw new JbpmException("no active jbpm context");
        }
    }

    public void createTimer(Timer timer) {
        ObjectFactory objectFactory = this.jbpmContext.getObjectFactory();
        if (objectFactory.hasObject(CALENDAR_RESOURCE)) {
            timer.setCalendarResource((String)objectFactory.createObject(CALENDAR_RESOURCE));
        }
        this.jbpmContext.getJobSession().saveJob(timer);
        this.hasProducedTimers = true;
    }

    public void deleteTimer(Timer timer) {
        this.jbpmContext.getJobSession().deleteJob(timer);
    }

    public void deleteTimersByName(String timerName, Token token) {
        this.jbpmContext.getJobSession().deleteTimersByName(timerName, token);
    }

    public void deleteTimersByProcessInstance(ProcessInstance processInstance) {
        this.jbpmContext.getJobSession().deleteJobsForProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.hasProducedTimers) {
            return;
        }
        JobExecutor jobExecutor = this.jbpmContext.getJbpmConfiguration().getJobExecutor();
        if (jobExecutor != null) {
            JobExecutor jobExecutor2 = jobExecutor;
            synchronized (jobExecutor2) {
                jobExecutor.notify();
            }
        }
    }
}

