/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jbpm.JbpmException;
import org.jbpm.db.JbpmSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.node.ProcessState;
import org.jbpm.logging.log.ProcessLog;

public class GraphSession {
    JbpmSession jbpmSession = null;
    Session session = null;
    private static final Log log = LogFactory.getLog(GraphSession.class);

    public GraphSession(JbpmSession jbpmSession) {
        this.jbpmSession = jbpmSession;
        this.session = jbpmSession.getSession();
    }

    public GraphSession(Session session) {
        this.session = session;
        this.jbpmSession = new JbpmSession(session);
    }

    public void deployProcessDefinition(ProcessDefinition processDefinition) {
        String processDefinitionName = processDefinition.getName();
        if (processDefinitionName != null) {
            ProcessDefinition previousLatestVersion = this.findLatestProcessDefinition(processDefinitionName);
            if (previousLatestVersion != null) {
                processDefinition.setVersion(previousLatestVersion.getVersion() + 1);
            } else {
                processDefinition.setVersion(1);
            }
        } else {
            throw new JbpmException("process definition does not have a name");
        }
        this.session.save((Object)processDefinition);
    }

    public void saveProcessDefinition(ProcessDefinition processDefinition) {
        try {
            this.session.save((Object)processDefinition);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't save process definition '" + processDefinition + "'", e);
        }
    }

    public ProcessDefinition loadProcessDefinition(long processDefinitionId) {
        try {
            return (ProcessDefinition)this.session.load(ProcessDefinition.class, (Serializable)new Long(processDefinitionId));
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't load process definition '" + processDefinitionId + "'", e);
        }
    }

    public ProcessDefinition getProcessDefinition(long processDefinitionId) {
        try {
            return (ProcessDefinition)this.session.get(ProcessDefinition.class, (Serializable)new Long(processDefinitionId));
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get process definition '" + processDefinitionId + "'", e);
        }
    }

    public ProcessDefinition findProcessDefinition(String name, int version) {
        ProcessDefinition processDefinition = null;
        try {
            Query query = this.session.getNamedQuery("GraphSession.findProcessDefinitionByNameAndVersion");
            query.setString("name", name);
            query.setInteger("version", version);
            processDefinition = (ProcessDefinition)query.uniqueResult();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get process definition with name '" + name + "' and version '" + version + "'", e);
        }
        return processDefinition;
    }

    public ProcessDefinition findLatestProcessDefinition(String name) {
        ProcessDefinition processDefinition = null;
        try {
            Query query = this.session.getNamedQuery("GraphSession.findLatestProcessDefinitionQuery");
            query.setString("name", name);
            query.setMaxResults(1);
            processDefinition = (ProcessDefinition)query.uniqueResult();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't find process definition '" + name + "'", e);
        }
        return processDefinition;
    }

    public List findLatestProcessDefinitions() {
        ArrayList<Object> processDefinitions = new ArrayList();
        HashMap<String, ProcessDefinition> processDefinitionsByName = new HashMap<String, ProcessDefinition>();
        try {
            Query query = this.session.getNamedQuery("GraphSession.findAllProcessDefinitions");
            for (ProcessDefinition processDefinition : query.list()) {
                String processDefinitionName = processDefinition.getName();
                ProcessDefinition previous = (ProcessDefinition)processDefinitionsByName.get(processDefinitionName);
                if (previous != null && previous.getVersion() >= processDefinition.getVersion()) continue;
                processDefinitionsByName.put(processDefinitionName, processDefinition);
            }
            processDefinitions = new ArrayList(processDefinitionsByName.values());
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't find latest versions of process definitions", e);
        }
        return processDefinitions;
    }

    public List findAllProcessDefinitions() {
        try {
            Query query = this.session.getNamedQuery("GraphSession.findAllProcessDefinitions");
            return query.list();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't find all process definitions", e);
        }
    }

    public List findAllProcessDefinitionVersions(String name) {
        try {
            Query query = this.session.getNamedQuery("GraphSession.findAllProcessDefinitionVersions");
            query.setString("name", name);
            return query.list();
        }
        catch (HibernateException e) {
            log.error((Object)e);
            throw new JbpmException("couldn't find all versions of process definition '" + name + "'", e);
        }
    }

    public void deleteProcessDefinition(long processDefinitionId) {
        this.deleteProcessDefinition(this.loadProcessDefinition(processDefinitionId));
    }

    public void deleteProcessDefinition(ProcessDefinition processDefinition) {
        if (processDefinition == null) {
            throw new JbpmException("processDefinition is null");
        }
        try {
            ProcessInstance processInstance;
            while ((processInstance = this.findNextProcessInstance(processDefinition)) != null) {
                this.deleteProcessInstance(processInstance);
            }
            List referencingProcessStates = this.findReferencingProcessStates(processDefinition);
            for (ProcessState processState : referencingProcessStates) {
                processState.setSubProcessDefinition(null);
            }
            this.session.delete((Object)processDefinition);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't delete process definition '" + processDefinition.getId() + "'", e);
        }
    }

    protected ProcessInstance findNextProcessInstance(ProcessDefinition processDefinition) {
        return (ProcessInstance)this.session.createCriteria(ProcessInstance.class).add((Criterion)Restrictions.eq((String)"processDefinition", (Object)processDefinition)).setMaxResults(1).uniqueResult();
    }

    protected List findReferencingProcessStates(ProcessDefinition subProcessDefinition) {
        Query query = this.session.getNamedQuery("GraphSession.findReferencingProcessStates");
        query.setEntity("subProcessDefinition", (Object)subProcessDefinition);
        return query.list();
    }

    public void saveProcessInstance(ProcessInstance processInstance) {
        throw new UnsupportedOperationException("use JbpmContext.save(ProcessInstance) instead");
    }

    public ProcessInstance loadProcessInstance(long processInstanceId) {
        try {
            ProcessInstance processInstance = (ProcessInstance)this.session.load(ProcessInstance.class, (Serializable)new Long(processInstanceId));
            return processInstance;
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't load process instance '" + processInstanceId + "'", e);
        }
    }

    public ProcessInstance getProcessInstance(long processInstanceId) {
        try {
            ProcessInstance processInstance = (ProcessInstance)this.session.get(ProcessInstance.class, (Serializable)new Long(processInstanceId));
            return processInstance;
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get process instance '" + processInstanceId + "'", e);
        }
    }

    public Token loadToken(long tokenId) {
        try {
            Token token = (Token)this.session.load(Token.class, (Serializable)new Long(tokenId));
            return token;
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't load token '" + tokenId + "'", e);
        }
    }

    public Token getToken(long tokenId) {
        try {
            Token token = (Token)this.session.get(Token.class, (Serializable)new Long(tokenId));
            return token;
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get token '" + tokenId + "'", e);
        }
    }

    public void lockProcessInstance(long processInstanceId) {
        this.lockProcessInstance(this.loadProcessInstance(processInstanceId));
    }

    public void lockProcessInstance(ProcessInstance processInstance) {
        try {
            this.session.lock((Object)processInstance, LockMode.UPGRADE);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't lock process instance '" + processInstance.getId() + "'", e);
        }
    }

    public List findProcessInstances(long processDefinitionId) {
        List processInstances = null;
        try {
            Query query = this.session.getNamedQuery("GraphSession.findAllProcessInstancesForADefinition");
            query.setLong("processDefinitionId", processDefinitionId);
            processInstances = query.list();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't load process instances for process definition '" + processDefinitionId + "'", e);
        }
        return processInstances;
    }

    public void deleteProcessInstance(long processInstanceId) {
        this.deleteProcessInstance(this.loadProcessInstance(processInstanceId));
    }

    public void deleteProcessInstance(ProcessInstance processInstance) {
        this.deleteProcessInstance(processInstance, true, true);
    }

    public void deleteProcessInstance(ProcessInstance processInstance, boolean includeTasks, boolean includeJobs) {
        if (processInstance == null) {
            throw new JbpmException("processInstance is null in JbpmSession.deleteProcessInstance()");
        }
        log.debug((Object)("deleting process instance " + processInstance.getId()));
        try {
            Query query;
            if (includeJobs) {
                log.debug((Object)("deleting jobs for process instance " + processInstance.getId()));
                query = this.session.getNamedQuery("GraphSession.deleteJobsForProcessInstance");
                query.setEntity("processInstance", (Object)processInstance);
                query.executeUpdate();
            }
            if (includeTasks) {
                query = this.session.getNamedQuery("GraphSession.findTaskInstanceIdsForProcessInstance");
                query.setEntity("processInstance", (Object)processInstance);
                List taskInstanceIds = query.list();
                if (taskInstanceIds != null && !taskInstanceIds.isEmpty()) {
                    log.debug((Object)("deleting tasks " + taskInstanceIds + " for process instance " + processInstance.getId()));
                    query = this.session.getNamedQuery("GraphSession.deleteTaskInstancesById");
                    query.setParameterList("taskInstanceIds", (Collection)taskInstanceIds);
                }
            }
            log.debug((Object)("deleting logs for process instance " + processInstance.getId()));
            this.deleteLogs(processInstance);
            log.debug((Object)("deleting subprocesses for process instance " + processInstance.getId()));
            this.deleteSubProcesses(processInstance.getRootToken());
            Token superProcessToken = processInstance.getSuperProcessToken();
            if (superProcessToken != null) {
                log.debug((Object)("nulling property subProcessInstance in superProcessToken " + superProcessToken.getId() + " which is referencing the process instance " + processInstance.getId() + " which is being deleted"));
                superProcessToken.setSubProcessInstance(null);
            }
            log.debug((Object)("hibernate session delete for process instance " + processInstance.getId()));
            this.session.delete((Object)processInstance);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't delete process instance '" + processInstance.getId() + "'", e);
        }
    }

    void deleteLogs(ProcessInstance processInstance) {
        Query query = this.session.getNamedQuery("GraphSession.findLogsForProcessInstance");
        query.setEntity("processInstance", (Object)processInstance);
        List logs = query.list();
        for (ProcessLog processLog : logs) {
            this.session.delete((Object)processLog);
        }
    }

    void deleteSubProcesses(Token token) {
        if (token != null) {
            Query query = this.session.getNamedQuery("GraphSession.findSubProcessInstances");
            query.setEntity("processInstance", (Object)token.getProcessInstance());
            List processInstances = query.list();
            if (processInstances == null || processInstances.isEmpty()) {
                log.debug((Object)("no subprocesses to delete for token " + token.getId()));
                return;
            }
            for (ProcessInstance subProcessInstance : processInstances) {
                subProcessInstance.setSuperProcessToken(null);
                token.setSubProcessInstance(null);
                log.debug((Object)("deleting sub process " + subProcessInstance.getId()));
                this.deleteProcessInstance(subProcessInstance);
            }
        }
    }

    public List calculateAverageTimeByNode(long processDefinitionId, long minumumDurationMillis) {
        ArrayList<AverageNodeTimeEntry> results = null;
        try {
            Query query = this.session.getNamedQuery("GraphSession.calculateAverageTimeByNode");
            query.setLong("processDefinitionId", processDefinitionId);
            query.setDouble("minimumDuration", (double)minumumDurationMillis);
            List listResults = query.list();
            if (listResults != null) {
                results = new ArrayList<AverageNodeTimeEntry>();
                for (Object[] values : listResults) {
                    AverageNodeTimeEntry averageNodeTimeEntry = new AverageNodeTimeEntry();
                    averageNodeTimeEntry.setNodeId(((Number)values[0]).longValue());
                    averageNodeTimeEntry.setNodeName((String)values[1]);
                    averageNodeTimeEntry.setCount(((Number)values[2]).intValue());
                    averageNodeTimeEntry.setAverageDuration(((Number)values[3]).longValue());
                    averageNodeTimeEntry.setMinDuration(((Number)values[4]).longValue());
                    averageNodeTimeEntry.setMaxDuration(((Number)values[5]).longValue());
                    results.add(averageNodeTimeEntry);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't load process instances for process definition '" + processDefinitionId + "'", e);
        }
        return results;
    }

    public List findActiveNodesByProcessInstance(ProcessInstance processInstance) {
        List results = null;
        try {
            Query query = this.session.getNamedQuery("GraphSession.findActiveNodesByProcessInstance");
            query.setEntity("processInstance", (Object)processInstance);
            results = query.list();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't active nodes for process instance '" + processInstance + "'", e);
        }
        return results;
    }

    public ProcessInstance getProcessInstance(ProcessDefinition processDefinition, String key) {
        ProcessInstance processInstance = null;
        try {
            Query query = this.session.getNamedQuery("GraphSession.findProcessInstanceByKey");
            query.setEntity("processDefinition", (Object)processDefinition);
            query.setString("key", key);
            processInstance = (ProcessInstance)query.uniqueResult();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't get process instance with key '" + key + "'", e);
        }
        return processInstance;
    }

    public ProcessInstance loadProcessInstance(ProcessDefinition processDefinition, String key) {
        ProcessInstance processInstance = null;
        try {
            Query query = this.session.getNamedQuery("GraphSession.findProcessInstanceByKey");
            query.setEntity("processDefinition", (Object)processDefinition);
            query.setString("key", key);
            processInstance = (ProcessInstance)query.uniqueResult();
            if (processInstance == null) {
                throw new JbpmException("no process instance was found with key " + key);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new JbpmException("couldn't load process instance with key '" + key + "'", e);
        }
        return processInstance;
    }

    public static class AverageNodeTimeEntry {
        private long nodeId;
        private String nodeName;
        private int count;
        private long averageDuration;
        private long minDuration;
        private long maxDuration;

        public long getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(long nodeId) {
            this.nodeId = nodeId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public long getAverageDuration() {
            return this.averageDuration;
        }

        public void setAverageDuration(long averageDuration) {
            this.averageDuration = averageDuration;
        }

        public long getMinDuration() {
            return this.minDuration;
        }

        public void setMinDuration(long minDuration) {
            this.minDuration = minDuration;
        }

        public long getMaxDuration() {
            return this.maxDuration;
        }

        public void setMaxDuration(long maxDuration) {
            this.maxDuration = maxDuration;
        }
    }
}

