/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.db;

import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StaleStateException;
import org.hibernate.Transaction;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.db.ContextSession;
import org.jbpm.db.GraphSession;
import org.jbpm.db.JobSession;
import org.jbpm.db.LoggingSession;
import org.jbpm.db.TaskMgmtSession;
import org.jbpm.persistence.JbpmPersistenceException;
import org.jbpm.persistence.PersistenceService;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.jbpm.persistence.db.StaleObjectLogConfigurer;
import org.jbpm.svc.Service;
import org.jbpm.svc.Services;
import org.jbpm.tx.TxService;

public class DbPersistenceService
implements Service,
PersistenceService {
    private static final long serialVersionUID = 1L;
    protected DbPersistenceServiceFactory persistenceServiceFactory = null;
    protected Connection connection = null;
    protected boolean mustConnectionBeClosed = false;
    protected Transaction transaction = null;
    protected boolean isTransactionEnabled = true;
    protected boolean isCurrentSessionEnabled = false;
    protected Session session;
    protected boolean mustSessionBeFlushed = false;
    protected boolean mustSessionBeClosed = false;
    protected Services services = null;
    protected GraphSession graphSession = null;
    protected TaskMgmtSession taskMgmtSession = null;
    protected JobSession jobSession = null;
    protected ContextSession contextSession = null;
    protected LoggingSession loggingSession = null;
    private static Log log = LogFactory.getLog(DbPersistenceService.class);

    public DbPersistenceService(DbPersistenceServiceFactory persistenceServiceFactory) {
        this(persistenceServiceFactory, DbPersistenceService.getCurrentServices());
    }

    static Services getCurrentServices() {
        Services services = null;
        JbpmContext currentJbpmContext = JbpmContext.getCurrentJbpmContext();
        if (currentJbpmContext != null) {
            services = currentJbpmContext.getServices();
        }
        return services;
    }

    DbPersistenceService(DbPersistenceServiceFactory persistenceServiceFactory, Services services) {
        this.persistenceServiceFactory = persistenceServiceFactory;
        this.isTransactionEnabled = persistenceServiceFactory.isTransactionEnabled();
        this.isCurrentSessionEnabled = persistenceServiceFactory.isCurrentSessionEnabled();
        this.services = services;
    }

    public SessionFactory getSessionFactory() {
        return this.session != null ? this.session.getSessionFactory() : this.persistenceServiceFactory.getSessionFactory();
    }

    public Session getSession() {
        if (this.session == null && this.getSessionFactory() != null) {
            Connection connection = this.getConnection(false);
            if (this.isCurrentSessionEnabled) {
                log.debug((Object)"using current hibernate session");
                this.session = this.getSessionFactory().getCurrentSession();
                this.mustSessionBeClosed = false;
                this.mustSessionBeFlushed = false;
                this.mustConnectionBeClosed = false;
            } else if (connection != null) {
                log.debug((Object)("creating hibernate session with connection " + connection));
                this.session = this.getSessionFactory().openSession(connection);
                this.mustSessionBeClosed = true;
                this.mustSessionBeFlushed = true;
                this.mustConnectionBeClosed = false;
            } else {
                log.debug((Object)"creating hibernate session");
                this.session = this.getSessionFactory().openSession();
                this.mustSessionBeClosed = true;
                this.mustSessionBeFlushed = true;
                this.mustConnectionBeClosed = false;
            }
            if (this.isTransactionEnabled) {
                this.beginTransaction();
            }
        }
        return this.session;
    }

    public void beginTransaction() {
        log.debug((Object)"beginning hibernate transaction");
        this.transaction = this.session.beginTransaction();
        log.debug((Object)("begun hibernate transaction " + this.transaction.toString()));
    }

    public void endTransaction() {
        if (this.isTransactionEnabled && this.transaction != null) {
            if (this.isRollbackOnly()) {
                try {
                    log.debug((Object)("rolling back hibernate transaction " + this.transaction.toString()));
                    this.mustSessionBeFlushed = false;
                    this.transaction.rollback();
                }
                catch (Exception e) {
                    throw new JbpmPersistenceException("couldn't rollback hibernate session", e);
                }
            }
            try {
                log.debug((Object)("committing hibernate transaction " + this.transaction.toString()));
                this.mustSessionBeFlushed = false;
                this.transaction.commit();
            }
            catch (Exception e) {
                try {
                    this.transaction.rollback();
                }
                catch (Exception e2) {
                    log.error((Object)"problem rolling back after failed commit", (Throwable)e2);
                }
                throw new JbpmPersistenceException("couldn't commit hibernate session", e);
            }
        }
    }

    public Connection getConnection() {
        return this.getConnection(true);
    }

    public Connection getConnection(boolean resolveSession) {
        if (this.connection == null) {
            if (this.persistenceServiceFactory.getDataSource() != null) {
                try {
                    log.debug((Object)"fetching jdbc connection from datasource");
                    this.connection = this.persistenceServiceFactory.getDataSource().getConnection();
                    this.mustConnectionBeClosed = true;
                }
                catch (Exception e) {
                    throw new JbpmException("couldn't obtain connection from datasource", e);
                }
            } else {
                if (resolveSession) {
                    this.getSession();
                }
                if (this.session != null) {
                    this.connection = this.session.connection();
                    log.debug((Object)("fetching connection from hibernate session. this transfers responsibility for closing the jdbc connection to the user! " + this.connection));
                    this.mustConnectionBeClosed = false;
                }
            }
        }
        return this.connection;
    }

    public boolean isTransactionActive() {
        return this.transaction != null && this.transaction.isActive();
    }

    protected boolean isTransactionExternallyManaged() {
        return !this.isTransactionEnabled || this.transaction == null;
    }

    public void close() {
        Exception flushException;
        if (this.session != null && this.isTransactionExternallyManaged() && this.isRollbackOnly()) {
            throw new JbpmException("setRollbackOnly was invoked while transaction is being managed externally");
        }
        if (this.isTransactionEnabled && this.transaction != null) {
            if (!this.isRollbackOnly()) {
                Exception commitException = this.commit();
                if (commitException != null) {
                    this.rollback();
                    this.closeSession();
                    this.closeConnection();
                    throw new JbpmPersistenceException("hibernate commit failed", commitException);
                }
            } else {
                Exception rollbackException = this.rollback();
                if (rollbackException != null) {
                    this.closeSession();
                    this.closeConnection();
                    throw new JbpmPersistenceException("hibernate rollback failed", rollbackException);
                }
            }
        }
        if ((flushException = this.flushSession()) != null) {
            this.closeSession();
            this.closeConnection();
            throw new JbpmPersistenceException("hibernate flush failed", flushException);
        }
        Exception closeSessionException = this.closeSession();
        if (closeSessionException != null) {
            this.closeConnection();
            throw new JbpmPersistenceException("hibernate close session failed", closeSessionException);
        }
        Exception closeConnectionException = this.closeConnection();
        if (closeConnectionException != null) {
            throw new JbpmPersistenceException("hibernate close connection failed", closeConnectionException);
        }
    }

    Exception commit() {
        try {
            log.debug((Object)("committing " + this.transaction));
            this.mustSessionBeFlushed = false;
            this.transaction.commit();
        }
        catch (StaleStateException e) {
            log.info((Object)"problem committing transaction: optimistic locking failed");
            StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)("optimistic locking failed while committing " + this.transaction), (Throwable)e);
            return e;
        }
        catch (Exception e) {
            log.error((Object)"hibernate commit failed", (Throwable)e);
            return e;
        }
        return null;
    }

    Exception flushSession() {
        if (this.mustSessionBeFlushed) {
            try {
                log.debug((Object)("flushing " + this.session));
                this.session.flush();
            }
            catch (StaleStateException e) {
                log.info((Object)"problem flushing session: optimistic locking failed");
                StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)("optimistic locking failed while flushing " + this.session), (Throwable)e);
                return e;
            }
            catch (Exception e) {
                log.error((Object)"hibernate flush failed", (Throwable)e);
                return e;
            }
        }
        return null;
    }

    Exception closeConnection() {
        if (this.mustConnectionBeClosed) {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    log.debug((Object)"closing jdbc connection");
                    this.connection.close();
                } else {
                    log.warn((Object)"jdbc connection was already closed");
                }
            }
            catch (Exception e) {
                log.error((Object)"hibernate session close failed", (Throwable)e);
                return e;
            }
        }
        return null;
    }

    Exception rollback() {
        try {
            log.debug((Object)"rolling back hibernate transaction");
            this.mustSessionBeFlushed = false;
            this.transaction.rollback();
        }
        catch (Exception e) {
            log.error((Object)"hibernate rollback failed", (Throwable)e);
            return e;
        }
        return null;
    }

    Exception closeSession() {
        if (this.mustSessionBeClosed) {
            try {
                if (this.session.isOpen()) {
                    log.debug((Object)"closing hibernate session");
                    this.session.close();
                } else {
                    log.warn((Object)"hibernate session was already closed");
                }
            }
            catch (Exception e) {
                return e;
            }
        }
        return null;
    }

    public void assignId(Object object) {
        try {
            this.getSession().save(object);
        }
        catch (Exception e) {
            throw new JbpmPersistenceException("couldn't assign id to " + object, e);
        }
    }

    public GraphSession getGraphSession() {
        Session session;
        if (this.graphSession == null && (session = this.getSession()) != null) {
            this.graphSession = new GraphSession(session);
        }
        return this.graphSession;
    }

    public LoggingSession getLoggingSession() {
        Session session;
        if (this.loggingSession == null && (session = this.getSession()) != null) {
            this.loggingSession = new LoggingSession(session);
        }
        return this.loggingSession;
    }

    public JobSession getJobSession() {
        Session session;
        if (this.jobSession == null && (session = this.getSession()) != null) {
            this.jobSession = new JobSession(session);
        }
        return this.jobSession;
    }

    public ContextSession getContextSession() {
        Session session;
        if (this.contextSession == null && (session = this.getSession()) != null) {
            this.contextSession = new ContextSession(session);
        }
        return this.contextSession;
    }

    public TaskMgmtSession getTaskMgmtSession() {
        Session session;
        if (this.taskMgmtSession == null && (session = this.getSession()) != null) {
            this.taskMgmtSession = new TaskMgmtSession(session);
        }
        return this.taskMgmtSession;
    }

    public DataSource getDataSource() {
        return this.persistenceServiceFactory.dataSource;
    }

    public boolean isRollbackOnly() {
        TxService txService;
        TxService txService2 = txService = this.services != null ? this.services.getTxService() : null;
        if (txService == null) {
            throw new JbpmException("no jbpm tx service configured");
        }
        return txService.isRollbackOnly();
    }

    public void setRollbackOnly(boolean isRollbackOnly) {
        throw new UnsupportedOperationException("method setRollbackOnly has been removed.  Use TxService instead.");
    }

    public void setRollbackOnly() {
        TxService txService;
        TxService txService2 = txService = this.services != null ? this.services.getTxService() : null;
        if (txService == null) {
            throw new JbpmException("no jbpm tx service configured");
        }
        txService.setRollbackOnly();
    }

    public void setSession(Session session) {
        this.session = session;
        log.debug((Object)"injecting a session disables transaction");
        this.isTransactionEnabled = false;
    }

    public void setSessionWithoutDisablingTx(Session session) {
        this.session = session;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setContextSession(ContextSession contextSession) {
        this.contextSession = contextSession;
    }

    public void setDataSource(DataSource dataSource) {
        this.persistenceServiceFactory.dataSource = dataSource;
    }

    public void setGraphSession(GraphSession graphSession) {
        this.graphSession = graphSession;
    }

    public void setLoggingSession(LoggingSession loggingSession) {
        this.loggingSession = loggingSession;
    }

    public void setJobSession(JobSession jobSession) {
        this.jobSession = jobSession;
    }

    public void setTaskMgmtSession(TaskMgmtSession taskMgmtSession) {
        this.taskMgmtSession = taskMgmtSession;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.persistenceServiceFactory.sessionFactory = sessionFactory;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public boolean isTransactionEnabled() {
        return this.isTransactionEnabled;
    }

    public void setTransactionEnabled(boolean isTransactionEnabled) {
        this.isTransactionEnabled = isTransactionEnabled;
    }
}

