/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.jta;

import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.util.JTAHelper;
import org.jbpm.JbpmException;
import org.jbpm.persistence.JbpmPersistenceException;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.jta.JtaDbPersistenceServiceFactory;

public class JtaDbPersistenceService
extends DbPersistenceService {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(JtaDbPersistenceService.class);
    private UserTransaction userTransaction;

    public JtaDbPersistenceService(JtaDbPersistenceServiceFactory persistenceServiceFactory) {
        super(persistenceServiceFactory);
        if (!this.isJtaTransactionInProgress()) {
            this.beginUserTransaction();
        }
    }

    public boolean isTransactionActive() {
        return this.isJtaTransactionInProgress();
    }

    protected boolean isTransactionExternallyManaged() {
        return !this.isJtaTxCreated();
    }

    public void close() {
        super.close();
        if (this.userTransaction != null) {
            this.endUserTransaction();
        }
    }

    boolean isJtaTransactionInProgress() {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)this.getSessionFactory();
        return JTAHelper.isTransactionInProgress((SessionFactoryImplementor)sessionFactory);
    }

    void beginUserTransaction() {
        try {
            log.debug((Object)"begin user transaction");
            this.userTransaction = ((JtaDbPersistenceServiceFactory)this.persistenceServiceFactory).getUserTransaction();
            this.userTransaction.begin();
        }
        catch (Exception e) {
            throw new JbpmException("couldn't begin user transaction", e);
        }
    }

    void endUserTransaction() {
        if (this.isRollbackOnly() || JTAHelper.isRollback((int)this.getUserTransactionStatus())) {
            log.debug((Object)"rolling back user transaction");
            try {
                this.userTransaction.rollback();
            }
            catch (Exception e) {
                throw new JbpmPersistenceException("couldn't rollback user transaction", e);
            }
        }
        log.debug((Object)"committing user transaction");
        try {
            this.userTransaction.commit();
        }
        catch (Exception e) {
            throw new JbpmPersistenceException("couldn't commit user transaction", e);
        }
    }

    int getUserTransactionStatus() {
        try {
            return this.userTransaction.getStatus();
        }
        catch (SystemException e) {
            throw new JbpmPersistenceException("couldn't get status for user transaction", e);
        }
    }

    public boolean isJtaTxCreated() {
        return this.userTransaction != null;
    }
}

