/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.db;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.db.JobSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Timer;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.scheduler.SchedulerService;

public class DbSchedulerService
implements SchedulerService {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DbSchedulerService.class);
    JobSession jobSession = null;
    JobExecutor jobExecutor = null;
    boolean hasProducedJobs = false;

    public DbSchedulerService() {
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext == null) {
            throw new JbpmException("instantiation of the DbSchedulerService requires a current JbpmContext");
        }
        this.jobSession = jbpmContext.getJobSession();
        this.jobExecutor = jbpmContext.getJbpmConfiguration().getJobExecutor();
    }

    public void createTimer(Timer timerJob) {
        this.jobSession.saveJob(timerJob);
        this.hasProducedJobs = true;
    }

    public void deleteTimer(Timer timer) {
        this.jobSession.deleteJob(timer);
    }

    public void deleteTimersByName(String timerName, Token token) {
        this.jobSession.deleteTimersByName(timerName, token);
    }

    public void deleteTimersByProcessInstance(ProcessInstance processInstance) {
        this.jobSession.deleteJobsForProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.hasProducedJobs && this.jobExecutor != null) {
            log.debug((Object)"timers were produced, job executor will be signalled");
            JobExecutor jobExecutor = this.jobExecutor;
            synchronized (jobExecutor) {
                this.jobExecutor.notify();
            }
        }
    }
}

