/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jcr.impl;

import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.jcr.JcrService;
import org.jbpm.svc.Services;
import org.jbpm.tx.TxService;

public class JcrServiceImpl
implements JcrService {
    private static final long serialVersionUID = 1L;
    protected Session session = null;
    Services services = null;
    private static Log log = LogFactory.getLog(JcrServiceImpl.class);

    public JcrServiceImpl(Session session) {
        this.session = session;
        this.services = JbpmContext.getCurrentJbpmContext().getServices();
    }

    public Session getSession() {
        return this.session;
    }

    public void close() {
        TxService txService;
        log.debug((Object)"closing jcr session");
        TxService txService2 = txService = this.services != null ? this.services.getTxService() : null;
        if (txService != null) {
            if (txService.isRollbackOnly()) {
                log.debug((Object)"refreshing jcr session because tx service is marked with rollback-only");
                try {
                    this.session.refresh(false);
                }
                catch (Exception e) {
                    throw new JbpmException("couldn't refresh(rollback) JCR session", e);
                }
            } else {
                log.debug((Object)"committing non-JTA JCR session by invoking the session.save()");
                this.save();
            }
        } else {
            this.save();
        }
        try {
            this.session.logout();
        }
        catch (Exception e) {
            throw new JbpmException("couldn't save JCR session", e);
        }
    }

    private void save() {
        log.debug((Object)"saving jcr session");
        try {
            this.session.save();
        }
        catch (Exception e) {
            throw new JbpmException("couldn't save jackrabbit jcr session", e);
        }
    }
}

