/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.action;

import java.util.Date;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.node.EndState;
import org.jbpm.sim.def.JbpmSimulationClock;
import org.jbpm.sim.jpdl.SimulationInstance;

public class ProcessEndAction
extends Action {
    private static final long serialVersionUID = 6997732702890810365L;

    public void execute(ExecutionContext executionContext) throws Exception {
        SimulationInstance simulationInstance = (SimulationInstance)executionContext.getProcessInstance().getInstance(SimulationInstance.class);
        if (simulationInstance.getSimulationModel() == null || JbpmSimulationClock.currentTime == null) {
            return;
        }
        Date dateStart = executionContext.getProcessInstance().getStart();
        Date dateEnd = JbpmSimulationClock.currentTime;
        long duration = dateEnd.getTime() - dateStart.getTime();
        simulationInstance.getSimulationModel().reportProcessInstanceCycleTime(executionContext.getProcessDefinition(), JbpmSimulationClock.getAsDouble(duration));
        simulationInstance.getSimulationModel().reportProcessEndState((EndState)executionContext.getToken().getNode());
        simulationInstance.getSimulationModel().reportFinishedProcessInstance(executionContext.getProcessInstance());
    }
}

