/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.bam;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jbpm.sim.bam.ElementStatistics;
import org.jbpm.sim.bam.TransitionProbability;
import org.jbpm.sim.def.JbpmSimulationScenario;

public class BamSimulationProposal {
    private static final Log log = LogFactory.getLog((Class)BamSimulationProposal.class);
    private String processName;
    private int processVersion;
    private String[] swimlanes;
    private ArrayList stateProposals = new ArrayList();
    private ArrayList decisionProposals = new ArrayList();
    private ArrayList taskProposals = new ArrayList();
    private ElementStatistics processStatistics;

    public BamSimulationProposal() {
    }

    public BamSimulationProposal(String processName, int processVersion) {
        this.processName = processName;
        this.processVersion = processVersion;
    }

    public JbpmSimulationScenario getScenario() {
        return null;
    }

    public Element createScenarioConfigurationXml() {
        Element result = DocumentFactory.getInstance().createElement("scenario");
        result.addAttribute("name", "status_quo");
        this.addProcessToScenarioXml(result);
        return result;
    }

    public void addProcessToScenarioXml(Element scenario) {
        Element stateElement;
        String distName;
        Element simProcess = scenario.addElement("sim-process");
        simProcess.addAttribute("path", "/" + this.getProcessName() + "/processdefinition.xml");
        String startEventDistName = this.addErlangDistributionElement(scenario, this.getProcessStatistics());
        simProcess.addElement("process-overwrite").addAttribute("start-distribution", startEventDistName);
        HashSet<String> alreadyAddedSwimlanes = new HashSet<String>();
        Iterator iter = scenario.elementIterator("resource-pool");
        while (iter.hasNext()) {
            Element rp = (Element)iter.next();
            alreadyAddedSwimlanes.add(rp.attributeValue("name"));
        }
        for (int i = 0; i < this.swimlanes.length; ++i) {
            if (alreadyAddedSwimlanes.contains(this.swimlanes[i])) continue;
            Element rp = scenario.addElement("resource-pool");
            rp.addAttribute("name", this.swimlanes[i]);
            rp.addAttribute("pool-size", "1");
            rp.addAttribute("costs-per-time-unit", "1");
            alreadyAddedSwimlanes.add(this.swimlanes[i]);
        }
        iter = this.stateProposals.iterator();
        while (iter.hasNext()) {
            ElementStatistics statistics = (ElementStatistics)iter.next();
            distName = this.addNormalDistributionElement(scenario, statistics);
            stateElement = simProcess.addElement("state-overwrite");
            stateElement.addAttribute("state-name", statistics.getName());
            stateElement.addAttribute("time-distribution", distName);
            this.addLeavingTransitionElements(statistics, stateElement);
        }
        iter = this.decisionProposals.iterator();
        while (iter.hasNext()) {
            ElementStatistics statistics = (ElementStatistics)iter.next();
            Element stateElement2 = simProcess.addElement("decision-overwrite");
            stateElement2.addAttribute("decision-name", statistics.getName());
            this.addLeavingTransitionElements(statistics, stateElement2);
        }
        iter = this.taskProposals.iterator();
        while (iter.hasNext()) {
            ElementStatistics statistics = (ElementStatistics)iter.next();
            distName = this.addNormalDistributionElement(scenario, statistics);
            stateElement = simProcess.addElement("task-overwrite");
            stateElement.addAttribute("task-name", statistics.getName());
            stateElement.addAttribute("time-distribution", distName);
            this.addLeavingTransitionElements(statistics, stateElement);
        }
    }

    private void addLeavingTransitionElements(ElementStatistics statistics, Element stateElement) {
        TransitionProbability[] transitionProbabilities = statistics.getLeavingTransitionProbabilities();
        for (int i = 0; i < transitionProbabilities.length; ++i) {
            Element transitionElement = stateElement.addElement("transition");
            transitionElement.addAttribute("name", transitionProbabilities[i].getTransitionName());
            transitionElement.addAttribute("probability", String.valueOf(transitionProbabilities[i].getCount()));
        }
    }

    private String addErlangDistributionElement(Element scenario, ElementStatistics stat) {
        return this.addDistributionElement(scenario, stat, "erlang", "real");
    }

    private String addNormalDistributionElement(Element scenario, ElementStatistics stat) {
        return this.addDistributionElement(scenario, stat, "normal", "real");
    }

    private String addDistributionElement(Element scenario, ElementStatistics stat, String type, String sampleType) {
        String name = this.getProcessName() + "." + stat.getName();
        Element dist = scenario.addElement("distribution");
        dist.addAttribute("name", name);
        dist.addAttribute("sample-type", sampleType);
        dist.addAttribute("type", type);
        dist.addAttribute("mean", String.valueOf(stat.getDurationAverage()));
        dist.addAttribute("standardDeviation", String.valueOf(stat.getDurationStddev()));
        return name;
    }

    public void addStateProposal(ElementStatistics stat) {
        this.stateProposals.add(stat);
    }

    public ElementStatistics[] getStateProposals() {
        return this.stateProposals.toArray(new ElementStatistics[0]);
    }

    public void addDecisionProposal(ElementStatistics statistics) {
        this.decisionProposals.add(statistics);
    }

    public ElementStatistics[] getDecisionProposals() {
        return this.decisionProposals.toArray(new ElementStatistics[0]);
    }

    public void addTaskProposal(ElementStatistics statistics) {
        this.taskProposals.add(statistics);
    }

    public ElementStatistics[] getTaskProposals() {
        return this.taskProposals.toArray(new ElementStatistics[0]);
    }

    public static void print(Element scenarioXml) {
        log.debug((Object)BamSimulationProposal.getXmlAsString(scenarioXml));
    }

    public static String getXmlAsString(Element scenarioXml) {
        StringWriter stringWriter = new StringWriter();
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, format);
            xmlWriter.write(scenarioXml);
        }
        catch (IOException ex) {
            throw new RuntimeException("couldn't write XML to string", ex);
        }
        return stringWriter.toString();
    }

    public static void print(BamSimulationProposal result) {
        int j;
        ElementStatistics stat;
        int i;
        log.debug((Object)("\n\n------ PROCESS " + result.getProcessName() + " / Version: " + result.getProcessVersion() + " ---------"));
        log.debug((Object)("  start event sample count    = " + result.getProcessStatistics().getSampleCount()));
        log.debug((Object)("  start event interval min    = " + result.getProcessStatistics().getDurationMin()));
        log.debug((Object)("  start event interval max    = " + result.getProcessStatistics().getDurationMax()));
        log.debug((Object)("  start event interval avg    = " + result.getProcessStatistics().getDurationAverage()));
        log.debug((Object)("  start event interval stddev = " + result.getProcessStatistics().getDurationStddev()));
        log.debug((Object)"\n------ STATEs ---------");
        for (i = 0; i < result.getStateProposals().length; ++i) {
            stat = result.getStateProposals()[i];
            log.debug((Object)(stat.getName() + ": "));
            log.debug((Object)("  sample count    = " + stat.getSampleCount()));
            log.debug((Object)("  duration min    = " + stat.getDurationMin()));
            log.debug((Object)("  duration max    = " + stat.getDurationMax()));
            log.debug((Object)("  duration avg    = " + stat.getDurationAverage()));
            log.debug((Object)("  duration stddev = " + stat.getDurationStddev()));
            for (j = 0; j < stat.getLeavingTransitionProbabilities().length; ++j) {
                log.debug((Object)("  -> " + stat.getLeavingTransitionProbabilities()[j].getTransitionName() + ": " + stat.getLeavingTransitionProbabilities()[j].getCount()));
            }
        }
        log.debug((Object)"\n------ DECISIONs ---------");
        for (i = 0; i < result.getDecisionProposals().length; ++i) {
            stat = result.getDecisionProposals()[i];
            log.debug((Object)(stat.getName() + ": "));
            log.debug((Object)("  sample count    = " + stat.getSampleCount()));
            log.debug((Object)("  duration min    = " + stat.getDurationMin()));
            log.debug((Object)("  duration max    = " + stat.getDurationMax()));
            log.debug((Object)("  duration avg    = " + stat.getDurationAverage()));
            log.debug((Object)("  duration stddev = " + stat.getDurationStddev()));
            for (j = 0; j < stat.getLeavingTransitionProbabilities().length; ++j) {
                log.debug((Object)("  -> " + stat.getLeavingTransitionProbabilities()[j].getTransitionName() + ": " + stat.getLeavingTransitionProbabilities()[j].getCount()));
            }
        }
        log.debug((Object)"\n------ TASKs ---------");
        for (i = 0; i < result.getTaskProposals().length; ++i) {
            stat = result.getTaskProposals()[i];
            log.debug((Object)(stat.getName() + ": "));
            log.debug((Object)("  sample count    = " + stat.getSampleCount()));
            log.debug((Object)("  duration min    = " + stat.getDurationMin()));
            log.debug((Object)("  duration max    = " + stat.getDurationMax()));
            log.debug((Object)("  duration avg    = " + stat.getDurationAverage()));
            log.debug((Object)("  duration stddev = " + stat.getDurationStddev()));
            for (j = 0; j < stat.getLeavingTransitionProbabilities().length; ++j) {
                log.debug((Object)("  -> " + stat.getLeavingTransitionProbabilities()[j].getTransitionName() + ": " + stat.getLeavingTransitionProbabilities()[j].getCount()));
            }
        }
    }

    public ElementStatistics getProcessStatistics() {
        return this.processStatistics;
    }

    public void setProcessStatistics(ElementStatistics processStatistics) {
        this.processStatistics = processStatistics;
    }

    public int getProcessVersion() {
        return this.processVersion;
    }

    public void setProcessVersion(int processVersion) {
        this.processVersion = processVersion;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String[] getSwimlanes() {
        return this.swimlanes;
    }

    public void setSwimlanes(String[] swimlanes) {
        this.swimlanes = swimlanes;
    }
}

