/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.report;

import org.jbpm.sim.report.AcklamStatUtil;

public class StatUtil {
    public static double getConfidenceIntervalSummand(double confidenceLevel, double standardDerivation, double sampleSize) {
        double z = AcklamStatUtil.getInvCDF(StatUtil.getInvCdfParam(confidenceLevel), true);
        double result = z * standardDerivation / Math.sqrt(sampleSize);
        return result;
    }

    public static double getRequiredSampleSize(double confidenceLevel, double halfConfidenceIntervalWidth, double standardDerivation) {
        double z = AcklamStatUtil.getInvCDF(StatUtil.getInvCdfParam(confidenceLevel), true);
        double result = Math.pow(z * standardDerivation / halfConfidenceIntervalWidth, 2.0);
        return result;
    }

    public static double getInvCdfParam(double confidenceLevel) {
        return 1.0 - (1.0 - confidenceLevel) / 2.0;
    }
}

