/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.exe;

import org.jbpm.sim.def.JbpmSimulationExperiment;
import org.jbpm.sim.exe.ExperimentReader;
import org.jbpm.sim.exe.SimulationProgressListener;
import org.jbpm.sim.report.ExperimentReport;
import org.jbpm.sim.report.ScenarioReport;
import org.jbpm.sim.report.jasper.ScenarioComparisionReport;
import org.jbpm.sim.report.jasper.ScenarioDetailsReport;
import org.xml.sax.InputSource;

public class JbpmSimulationExperimentRunner {
    private boolean showReport = true;
    private boolean async = true;
    private boolean createDesmojHtmlOutput = false;
    private boolean rememberEndedProcessInstances = false;
    private SimulationProgressListener progressListener = null;

    public JbpmSimulationExperimentRunner() {
    }

    public JbpmSimulationExperimentRunner(boolean showReport, boolean async, SimulationProgressListener progressListener) {
        this.showReport = showReport;
        this.async = async;
        this.progressListener = progressListener;
    }

    public void run(final String experimentConfigurationXml) {
        if (this.async) {
            new Thread(){

                public void run() {
                    JbpmSimulationExperimentRunner.this.doTheJob(experimentConfigurationXml);
                }
            }.start();
        } else {
            this.doTheJob(experimentConfigurationXml);
        }
    }

    private void doTheJob(String experimentConfigurationXmlPath) {
        ExperimentReader reader = new ExperimentReader(new InputSource(this.getClass().getResourceAsStream(experimentConfigurationXmlPath)));
        JbpmSimulationExperiment experiment = reader.readExperiment();
        experiment.setWriteDesmojHtmlOutput(this.createDesmojHtmlOutput);
        experiment.setRememberEndedProcessInstances(this.rememberEndedProcessInstances);
        experiment.run();
        ExperimentReport report = experiment.getReport();
        if (this.showReport) {
            this.showReport(report);
        }
    }

    private void showReport(ExperimentReport report) {
        if (report.getScenarioCount() == 1) {
            ScenarioReport sr = (ScenarioReport)report.getScenarioReports().iterator().next();
            ScenarioDetailsReport r = new ScenarioDetailsReport(sr);
            r.show();
        } else if (report.getScenarioCount() > 1) {
            ScenarioComparisionReport r = new ScenarioComparisionReport(report);
            r.show();
        }
    }

    public static void main() {
        String experimentConf = "/xyz/conf.xml";
        boolean showReport = true;
        boolean runAsync = true;
        SimulationProgressListener listener = new SimulationProgressListener(){

            public void newScenario(String scenarioName, int scenarioNumber, int scenarioCount) {
            }

            public void experimentFinished() {
            }

            public void progressChanged(double currentScenarioPercentage) {
            }
        };
        new JbpmSimulationExperimentRunner(showReport, runAsync, listener).run(experimentConf);
    }

    public void setCreateDesmojHtmlOutput(boolean createDesmojHtmlOutput) {
        this.createDesmojHtmlOutput = createDesmojHtmlOutput;
    }

    public boolean isRememberEndedProcessInstances() {
        return this.rememberEndedProcessInstances;
    }

    public void setRememberEndedProcessInstances(boolean rememberEndedProcessInstances) {
        this.rememberEndedProcessInstances = rememberEndedProcessInstances;
    }
}

