/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.entity;

import desmoj.core.simulator.Entity;
import desmoj.core.simulator.Model;
import desmoj.core.simulator.Queue;
import desmoj.core.simulator.SimTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jbpm.sim.def.JbpmSimulationModel;
import org.jbpm.sim.def.ResourceRequirement;
import org.jbpm.sim.entity.ResourceEntity;

public abstract class ResourceUsingEntity
extends Entity {
    private Map acquiredResourceEntities = new HashMap();
    private Set missingResources = new HashSet();
    private SimTime startWait;
    private SimTime endWait;
    private SimTime startWork;
    private SimTime endWork;
    private JbpmSimulationModel model;

    public ResourceUsingEntity(Model owner, String name, boolean showInTrace) {
        super(owner, name, showInTrace);
        this.model = (JbpmSimulationModel)owner;
    }

    protected JbpmSimulationModel getJbpmModel() {
        return this.model;
    }

    public abstract Object getEntityObject();

    protected abstract ResourceRequirement[] getRequiredResources();

    public boolean acquireResourcesAndStart() {
        this.startWait = this.currentTime();
        ResourceRequirement[] resources = this.getRequiredResources();
        for (int i = 0; i < resources.length; ++i) {
            if (this.consumeResources(resources[i].getResourcePoolName(), resources[i].getAmount())) continue;
            this.missingResources.add(resources[i].getResourcePoolName());
        }
        if (this.missingResources.size() == 0) {
            this.start();
            return true;
        }
        return false;
    }

    public boolean resourceReleased(String poolName) {
        if (!this.missingResources.contains(poolName)) {
            throw new RuntimeException("I am informed of a released resource, but I don't wait for it! Entity: " + this.getName() + "; poolName: '" + poolName + "'");
        }
        ResourceRequirement[] resources = this.getRequiredResources();
        for (int i = 0; i < resources.length; ++i) {
            if (!resources[i].getResourcePoolName().equals(poolName)) continue;
            if (!this.consumeResources(poolName, resources[i].getAmount())) break;
            this.missingResources.remove(poolName);
            break;
        }
        if (this.missingResources.size() == 0) {
            this.start();
            return true;
        }
        return false;
    }

    private boolean consumeResources(String poolName, int n) {
        Queue resourcePool = this.getJbpmModel().getResourcePool(poolName).getPool();
        if (n > resourcePool.getQueueLimit()) {
            throw new RuntimeException("can never handle this request for " + n + " resources of pool " + poolName + ", maximum of available resources is " + resourcePool.getQueueLimit());
        }
        if (resourcePool.isEmpty() || resourcePool.length() < n) {
            Queue q = this.getJbpmModel().getResourceQueue(poolName);
            q.insert((Entity)this);
            return false;
        }
        ResourceEntity[] result = new ResourceEntity[n];
        for (int i = 0; i < n; ++i) {
            result[i] = (ResourceEntity)resourcePool.first();
            resourcePool.remove((Entity)result[i]);
        }
        this.getJbpmModel().resourceUsageChanged(poolName);
        this.acquiredResourceEntities.put(poolName, result);
        return true;
    }

    public void releaseResources() {
        Object e = null;
        for (String poolName : this.acquiredResourceEntities.keySet()) {
            ResourceEntity[] resourceEntities = (ResourceEntity[])this.acquiredResourceEntities.get(poolName);
            for (int i = 0; i < resourceEntities.length; ++i) {
                this.getJbpmModel().getResourcePool(poolName).getPool().insert((Entity)resourceEntities[i]);
            }
            this.getJbpmModel().checkWaitingQueue(poolName);
            this.getJbpmModel().resourceUsageChanged(poolName);
        }
    }

    public void start() {
        this.endWait = this.currentTime();
        this.getJbpmModel().getEntityWaitTimeTally(this.getEntityObject()).update(this.getWaitTime());
        this.startWork = this.currentTime();
        this.doStart();
    }

    protected abstract void doStart();

    public void end() {
        this.endWork = this.currentTime();
        this.doEnd();
    }

    protected abstract void doEnd();

    public double getWaitTime() {
        if (this.startWait != null && this.endWait != null) {
            return this.endWait.getTimeValue() - this.startWait.getTimeValue();
        }
        return Double.NaN;
    }

    public double getWorkTime() {
        if (this.startWork != null && this.endWork != null) {
            return this.endWork.getTimeValue() - this.startWork.getTimeValue();
        }
        return Double.NaN;
    }
}

