/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.sim.report.ScenarioReport;

public class ExperimentReport {
    private String experimentName;
    private String currency;
    private Map scenarioReports = new HashMap();

    public ExperimentReport(String experimentName) {
        this.experimentName = experimentName;
        this.currency = "";
    }

    public ExperimentReport(String experimentName, String currency) {
        this.experimentName = experimentName;
        this.currency = currency;
    }

    public List getAllStateWaitingTimes() {
        ArrayList result = new ArrayList();
        for (ScenarioReport sr : this.scenarioReports.values()) {
            result.addAll(sr.getStateWaitingTimes());
        }
        return result;
    }

    public List getAllResourcePoolWaitingTimes() {
        ArrayList result = new ArrayList();
        for (ScenarioReport sr : this.scenarioReports.values()) {
            result.addAll(sr.getResourcePoolWaitingTimes());
        }
        return result;
    }

    public List getAllResourcePoolUtilizations() {
        ArrayList result = new ArrayList();
        for (ScenarioReport sr : this.scenarioReports.values()) {
            result.addAll(sr.getResourcePoolUtilizations());
        }
        return result;
    }

    public void addScenarioReport(ScenarioReport simulationReport) {
        this.scenarioReports.put(simulationReport.getScenarioName(), simulationReport);
    }

    public ScenarioReport getScenarioReport(String scenarioName) {
        return (ScenarioReport)this.scenarioReports.get(scenarioName);
    }

    public String getExperimentName() {
        return this.experimentName;
    }

    public int getScenarioCount() {
        return this.scenarioReports.keySet().size();
    }

    public Collection getScenarioReports() {
        return this.scenarioReports.values();
    }

    public String getCurrency() {
        return this.currency;
    }
}

